/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LabelName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/labels/{label}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String label;

    public String getCustomer() {
        return this.customer;
    }

    public String getLabel() {
        return this.label;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private LabelName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.label = (String)Preconditions.checkNotNull((Object)builder.getLabel());
    }

    public static LabelName of(String customer, String label) {
        return LabelName.newBuilder().setCustomer(customer).setLabel(label).build();
    }

    public static String format(String customer, String label) {
        return LabelName.newBuilder().setCustomer(customer).setLabel(label).build().toString();
    }

    public static LabelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "LabelName.parse: formattedString not in valid format");
        return LabelName.of((String)matchMap.get("customer"), (String)matchMap.get("label"));
    }

    public static List<LabelName> parseList(List<String> formattedStrings) {
        ArrayList<LabelName> list = new ArrayList<LabelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LabelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LabelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LabelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LabelName labelName = this;
            synchronized (labelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"label", (Object)this.label);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "label", this.label});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LabelName) {
            LabelName that = (LabelName)o;
            return this.customer.equals(that.customer) && this.label.equals(that.label);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.label.hashCode();
    }

    public static class Builder {
        private String customer;
        private String label;

        public String getCustomer() {
            return this.customer;
        }

        public String getLabel() {
            return this.label;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setLabel(String label) {
            this.label = label;
            return this;
        }

        private Builder() {
        }

        private Builder(LabelName labelName) {
            this.customer = labelName.customer;
            this.label = labelName.label;
        }

        public LabelName build() {
            return new LabelName(this);
        }
    }
}

