/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LandingPageViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/landingPageViews/{landing_page_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String landingPageView;

    public String getCustomer() {
        return this.customer;
    }

    public String getLandingPageView() {
        return this.landingPageView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private LandingPageViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.landingPageView = (String)Preconditions.checkNotNull((Object)builder.getLandingPageView());
    }

    public static LandingPageViewName of(String customer, String landingPageView) {
        return LandingPageViewName.newBuilder().setCustomer(customer).setLandingPageView(landingPageView).build();
    }

    public static String format(String customer, String landingPageView) {
        return LandingPageViewName.newBuilder().setCustomer(customer).setLandingPageView(landingPageView).build().toString();
    }

    public static LandingPageViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "LandingPageViewName.parse: formattedString not in valid format");
        return LandingPageViewName.of((String)matchMap.get("customer"), (String)matchMap.get("landing_page_view"));
    }

    public static List<LandingPageViewName> parseList(List<String> formattedStrings) {
        ArrayList<LandingPageViewName> list = new ArrayList<LandingPageViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LandingPageViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LandingPageViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LandingPageViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LandingPageViewName landingPageViewName = this;
            synchronized (landingPageViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"landingPageView", (Object)this.landingPageView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "landing_page_view", this.landingPageView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LandingPageViewName) {
            LandingPageViewName that = (LandingPageViewName)o;
            return this.customer.equals(that.customer) && this.landingPageView.equals(that.landingPageView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.landingPageView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String landingPageView;

        public String getCustomer() {
            return this.customer;
        }

        public String getLandingPageView() {
            return this.landingPageView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setLandingPageView(String landingPageView) {
            this.landingPageView = landingPageView;
            return this;
        }

        private Builder() {
        }

        private Builder(LandingPageViewName landingPageViewName) {
            this.customer = landingPageViewName.customer;
            this.landingPageView = landingPageViewName.landingPageView;
        }

        public LandingPageViewName build() {
            return new LandingPageViewName(this);
        }
    }
}

