/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LanguageConstantName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"languageConstants/{language_constant}");
    private volatile Map<String, String> fieldValuesMap;
    private final String languageConstant;

    public String getLanguageConstant() {
        return this.languageConstant;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private LanguageConstantName(Builder builder) {
        this.languageConstant = (String)Preconditions.checkNotNull((Object)builder.getLanguageConstant());
    }

    public static LanguageConstantName of(String languageConstant) {
        return LanguageConstantName.newBuilder().setLanguageConstant(languageConstant).build();
    }

    public static String format(String languageConstant) {
        return LanguageConstantName.newBuilder().setLanguageConstant(languageConstant).build().toString();
    }

    public static LanguageConstantName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "LanguageConstantName.parse: formattedString not in valid format");
        return LanguageConstantName.of((String)matchMap.get("language_constant"));
    }

    public static List<LanguageConstantName> parseList(List<String> formattedStrings) {
        ArrayList<LanguageConstantName> list = new ArrayList<LanguageConstantName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LanguageConstantName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LanguageConstantName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LanguageConstantName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LanguageConstantName languageConstantName = this;
            synchronized (languageConstantName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"languageConstant", (Object)this.languageConstant);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"language_constant", this.languageConstant});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LanguageConstantName) {
            LanguageConstantName that = (LanguageConstantName)o;
            return this.languageConstant.equals(that.languageConstant);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= this.languageConstant.hashCode();
    }

    public static class Builder {
        private String languageConstant;

        public String getLanguageConstant() {
            return this.languageConstant;
        }

        public Builder setLanguageConstant(String languageConstant) {
            this.languageConstant = languageConstant;
            return this;
        }

        private Builder() {
        }

        private Builder(LanguageConstantName languageConstantName) {
            this.languageConstant = languageConstantName.languageConstant;
        }

        public LanguageConstantName build() {
            return new LanguageConstantName(this);
        }
    }
}

