/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.ads.googleads.v5.resources.LanguageConstant;
import com.google.ads.googleads.v5.services.GetLanguageConstantRequest;
import com.google.ads.googleads.v5.services.LanguageConstantName;
import com.google.ads.googleads.v5.services.LanguageConstantServiceSettings;
import com.google.ads.googleads.v5.services.stub.LanguageConstantServiceStub;
import com.google.ads.googleads.v5.services.stub.LanguageConstantServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class LanguageConstantServiceClient
implements BackgroundResource {
    private final LanguageConstantServiceSettings settings;
    private final LanguageConstantServiceStub stub;

    public static final LanguageConstantServiceClient create() throws IOException {
        return LanguageConstantServiceClient.create(LanguageConstantServiceSettings.newBuilder().build());
    }

    public static final LanguageConstantServiceClient create(LanguageConstantServiceSettings settings) throws IOException {
        return new LanguageConstantServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final LanguageConstantServiceClient create(LanguageConstantServiceStub stub) {
        return new LanguageConstantServiceClient(stub);
    }

    protected LanguageConstantServiceClient(LanguageConstantServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((LanguageConstantServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected LanguageConstantServiceClient(LanguageConstantServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final LanguageConstantServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public LanguageConstantServiceStub getStub() {
        return this.stub;
    }

    public final LanguageConstant getLanguageConstant(LanguageConstantName resourceName) {
        GetLanguageConstantRequest request = GetLanguageConstantRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getLanguageConstant(request);
    }

    public final LanguageConstant getLanguageConstant(String resourceName) {
        GetLanguageConstantRequest request = GetLanguageConstantRequest.newBuilder().setResourceName(resourceName).build();
        return this.getLanguageConstant(request);
    }

    public final LanguageConstant getLanguageConstant(GetLanguageConstantRequest request) {
        return (LanguageConstant)this.getLanguageConstantCallable().call((Object)request);
    }

    public final UnaryCallable<GetLanguageConstantRequest, LanguageConstant> getLanguageConstantCallable() {
        return this.stub.getLanguageConstantCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

