/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LocationViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/locationViews/{location_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String locationView;

    public String getCustomer() {
        return this.customer;
    }

    public String getLocationView() {
        return this.locationView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private LocationViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.locationView = (String)Preconditions.checkNotNull((Object)builder.getLocationView());
    }

    public static LocationViewName of(String customer, String locationView) {
        return LocationViewName.newBuilder().setCustomer(customer).setLocationView(locationView).build();
    }

    public static String format(String customer, String locationView) {
        return LocationViewName.newBuilder().setCustomer(customer).setLocationView(locationView).build().toString();
    }

    public static LocationViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "LocationViewName.parse: formattedString not in valid format");
        return LocationViewName.of((String)matchMap.get("customer"), (String)matchMap.get("location_view"));
    }

    public static List<LocationViewName> parseList(List<String> formattedStrings) {
        ArrayList<LocationViewName> list = new ArrayList<LocationViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LocationViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LocationViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LocationViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LocationViewName locationViewName = this;
            synchronized (locationViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"locationView", (Object)this.locationView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "location_view", this.locationView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LocationViewName) {
            LocationViewName that = (LocationViewName)o;
            return this.customer.equals(that.customer) && this.locationView.equals(that.locationView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.locationView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String locationView;

        public String getCustomer() {
            return this.customer;
        }

        public String getLocationView() {
            return this.locationView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setLocationView(String locationView) {
            this.locationView = locationView;
            return this;
        }

        private Builder() {
        }

        private Builder(LocationViewName locationViewName) {
            this.customer = locationViewName.customer;
            this.locationView = locationViewName.locationView;
        }

        public LocationViewName build() {
            return new LocationViewName(this);
        }
    }
}

