/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ManagedPlacementViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/managedPlacementViews/{managed_placement_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String managedPlacementView;

    public String getCustomer() {
        return this.customer;
    }

    public String getManagedPlacementView() {
        return this.managedPlacementView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ManagedPlacementViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.managedPlacementView = (String)Preconditions.checkNotNull((Object)builder.getManagedPlacementView());
    }

    public static ManagedPlacementViewName of(String customer, String managedPlacementView) {
        return ManagedPlacementViewName.newBuilder().setCustomer(customer).setManagedPlacementView(managedPlacementView).build();
    }

    public static String format(String customer, String managedPlacementView) {
        return ManagedPlacementViewName.newBuilder().setCustomer(customer).setManagedPlacementView(managedPlacementView).build().toString();
    }

    public static ManagedPlacementViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ManagedPlacementViewName.parse: formattedString not in valid format");
        return ManagedPlacementViewName.of((String)matchMap.get("customer"), (String)matchMap.get("managed_placement_view"));
    }

    public static List<ManagedPlacementViewName> parseList(List<String> formattedStrings) {
        ArrayList<ManagedPlacementViewName> list = new ArrayList<ManagedPlacementViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ManagedPlacementViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ManagedPlacementViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ManagedPlacementViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ManagedPlacementViewName managedPlacementViewName = this;
            synchronized (managedPlacementViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"managedPlacementView", (Object)this.managedPlacementView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "managed_placement_view", this.managedPlacementView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ManagedPlacementViewName) {
            ManagedPlacementViewName that = (ManagedPlacementViewName)o;
            return this.customer.equals(that.customer) && this.managedPlacementView.equals(that.managedPlacementView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.managedPlacementView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String managedPlacementView;

        public String getCustomer() {
            return this.customer;
        }

        public String getManagedPlacementView() {
            return this.managedPlacementView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setManagedPlacementView(String managedPlacementView) {
            this.managedPlacementView = managedPlacementView;
            return this;
        }

        private Builder() {
        }

        private Builder(ManagedPlacementViewName managedPlacementViewName) {
            this.customer = managedPlacementViewName.customer;
            this.managedPlacementView = managedPlacementViewName.managedPlacementView;
        }

        public ManagedPlacementViewName build() {
            return new ManagedPlacementViewName(this);
        }
    }
}

