/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MediaFileName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/mediaFiles/{media_file}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String mediaFile;

    public String getCustomer() {
        return this.customer;
    }

    public String getMediaFile() {
        return this.mediaFile;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private MediaFileName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.mediaFile = (String)Preconditions.checkNotNull((Object)builder.getMediaFile());
    }

    public static MediaFileName of(String customer, String mediaFile) {
        return MediaFileName.newBuilder().setCustomer(customer).setMediaFile(mediaFile).build();
    }

    public static String format(String customer, String mediaFile) {
        return MediaFileName.newBuilder().setCustomer(customer).setMediaFile(mediaFile).build().toString();
    }

    public static MediaFileName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "MediaFileName.parse: formattedString not in valid format");
        return MediaFileName.of((String)matchMap.get("customer"), (String)matchMap.get("media_file"));
    }

    public static List<MediaFileName> parseList(List<String> formattedStrings) {
        ArrayList<MediaFileName> list = new ArrayList<MediaFileName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MediaFileName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MediaFileName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MediaFileName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MediaFileName mediaFileName = this;
            synchronized (mediaFileName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"mediaFile", (Object)this.mediaFile);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "media_file", this.mediaFile});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MediaFileName) {
            MediaFileName that = (MediaFileName)o;
            return this.customer.equals(that.customer) && this.mediaFile.equals(that.mediaFile);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.mediaFile.hashCode();
    }

    public static class Builder {
        private String customer;
        private String mediaFile;

        public String getCustomer() {
            return this.customer;
        }

        public String getMediaFile() {
            return this.mediaFile;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setMediaFile(String mediaFile) {
            this.mediaFile = mediaFile;
            return this;
        }

        private Builder() {
        }

        private Builder(MediaFileName mediaFileName) {
            this.customer = mediaFileName.customer;
            this.mediaFile = mediaFileName.mediaFile;
        }

        public MediaFileName build() {
            return new MediaFileName(this);
        }
    }
}

