/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.ads.googleads.v5.resources.MediaFile;
import com.google.ads.googleads.v5.services.GetMediaFileRequest;
import com.google.ads.googleads.v5.services.MediaFileName;
import com.google.ads.googleads.v5.services.MediaFileOperation;
import com.google.ads.googleads.v5.services.MediaFileServiceSettings;
import com.google.ads.googleads.v5.services.MutateMediaFilesRequest;
import com.google.ads.googleads.v5.services.MutateMediaFilesResponse;
import com.google.ads.googleads.v5.services.stub.MediaFileServiceStub;
import com.google.ads.googleads.v5.services.stub.MediaFileServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class MediaFileServiceClient
implements BackgroundResource {
    private final MediaFileServiceSettings settings;
    private final MediaFileServiceStub stub;

    public static final MediaFileServiceClient create() throws IOException {
        return MediaFileServiceClient.create(MediaFileServiceSettings.newBuilder().build());
    }

    public static final MediaFileServiceClient create(MediaFileServiceSettings settings) throws IOException {
        return new MediaFileServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final MediaFileServiceClient create(MediaFileServiceStub stub) {
        return new MediaFileServiceClient(stub);
    }

    protected MediaFileServiceClient(MediaFileServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MediaFileServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected MediaFileServiceClient(MediaFileServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final MediaFileServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public MediaFileServiceStub getStub() {
        return this.stub;
    }

    public final MediaFile getMediaFile(MediaFileName resourceName) {
        GetMediaFileRequest request = GetMediaFileRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getMediaFile(request);
    }

    public final MediaFile getMediaFile(String resourceName) {
        GetMediaFileRequest request = GetMediaFileRequest.newBuilder().setResourceName(resourceName).build();
        return this.getMediaFile(request);
    }

    public final MediaFile getMediaFile(GetMediaFileRequest request) {
        return (MediaFile)this.getMediaFileCallable().call((Object)request);
    }

    public final UnaryCallable<GetMediaFileRequest, MediaFile> getMediaFileCallable() {
        return this.stub.getMediaFileCallable();
    }

    public final MutateMediaFilesResponse mutateMediaFiles(String customerId, List<MediaFileOperation> operations) {
        MutateMediaFilesRequest request = MutateMediaFilesRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateMediaFiles(request);
    }

    public final MutateMediaFilesResponse mutateMediaFiles(MutateMediaFilesRequest request) {
        return (MutateMediaFilesResponse)this.mutateMediaFilesCallable().call((Object)request);
    }

    public final UnaryCallable<MutateMediaFilesRequest, MutateMediaFilesResponse> mutateMediaFilesCallable() {
        return this.stub.mutateMediaFilesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

