/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MerchantCenterLinkName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/merchantCenterLinks/{merchant_center_link}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String merchantCenterLink;

    public String getCustomer() {
        return this.customer;
    }

    public String getMerchantCenterLink() {
        return this.merchantCenterLink;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private MerchantCenterLinkName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.merchantCenterLink = (String)Preconditions.checkNotNull((Object)builder.getMerchantCenterLink());
    }

    public static MerchantCenterLinkName of(String customer, String merchantCenterLink) {
        return MerchantCenterLinkName.newBuilder().setCustomer(customer).setMerchantCenterLink(merchantCenterLink).build();
    }

    public static String format(String customer, String merchantCenterLink) {
        return MerchantCenterLinkName.newBuilder().setCustomer(customer).setMerchantCenterLink(merchantCenterLink).build().toString();
    }

    public static MerchantCenterLinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "MerchantCenterLinkName.parse: formattedString not in valid format");
        return MerchantCenterLinkName.of((String)matchMap.get("customer"), (String)matchMap.get("merchant_center_link"));
    }

    public static List<MerchantCenterLinkName> parseList(List<String> formattedStrings) {
        ArrayList<MerchantCenterLinkName> list = new ArrayList<MerchantCenterLinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MerchantCenterLinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MerchantCenterLinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MerchantCenterLinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MerchantCenterLinkName merchantCenterLinkName = this;
            synchronized (merchantCenterLinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"merchantCenterLink", (Object)this.merchantCenterLink);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "merchant_center_link", this.merchantCenterLink});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MerchantCenterLinkName) {
            MerchantCenterLinkName that = (MerchantCenterLinkName)o;
            return this.customer.equals(that.customer) && this.merchantCenterLink.equals(that.merchantCenterLink);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.merchantCenterLink.hashCode();
    }

    public static class Builder {
        private String customer;
        private String merchantCenterLink;

        public String getCustomer() {
            return this.customer;
        }

        public String getMerchantCenterLink() {
            return this.merchantCenterLink;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setMerchantCenterLink(String merchantCenterLink) {
            this.merchantCenterLink = merchantCenterLink;
            return this;
        }

        private Builder() {
        }

        private Builder(MerchantCenterLinkName merchantCenterLinkName) {
            this.customer = merchantCenterLinkName.customer;
            this.merchantCenterLink = merchantCenterLinkName.merchantCenterLink;
        }

        public MerchantCenterLinkName build() {
            return new MerchantCenterLinkName(this);
        }
    }
}

