/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MobileAppCategoryConstantName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"mobileAppCategoryConstants/{mobile_app_category_constant}");
    private volatile Map<String, String> fieldValuesMap;
    private final String mobileAppCategoryConstant;

    public String getMobileAppCategoryConstant() {
        return this.mobileAppCategoryConstant;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private MobileAppCategoryConstantName(Builder builder) {
        this.mobileAppCategoryConstant = (String)Preconditions.checkNotNull((Object)builder.getMobileAppCategoryConstant());
    }

    public static MobileAppCategoryConstantName of(String mobileAppCategoryConstant) {
        return MobileAppCategoryConstantName.newBuilder().setMobileAppCategoryConstant(mobileAppCategoryConstant).build();
    }

    public static String format(String mobileAppCategoryConstant) {
        return MobileAppCategoryConstantName.newBuilder().setMobileAppCategoryConstant(mobileAppCategoryConstant).build().toString();
    }

    public static MobileAppCategoryConstantName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "MobileAppCategoryConstantName.parse: formattedString not in valid format");
        return MobileAppCategoryConstantName.of((String)matchMap.get("mobile_app_category_constant"));
    }

    public static List<MobileAppCategoryConstantName> parseList(List<String> formattedStrings) {
        ArrayList<MobileAppCategoryConstantName> list = new ArrayList<MobileAppCategoryConstantName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MobileAppCategoryConstantName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MobileAppCategoryConstantName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MobileAppCategoryConstantName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MobileAppCategoryConstantName mobileAppCategoryConstantName = this;
            synchronized (mobileAppCategoryConstantName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"mobileAppCategoryConstant", (Object)this.mobileAppCategoryConstant);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"mobile_app_category_constant", this.mobileAppCategoryConstant});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MobileAppCategoryConstantName) {
            MobileAppCategoryConstantName that = (MobileAppCategoryConstantName)o;
            return this.mobileAppCategoryConstant.equals(that.mobileAppCategoryConstant);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= this.mobileAppCategoryConstant.hashCode();
    }

    public static class Builder {
        private String mobileAppCategoryConstant;

        public String getMobileAppCategoryConstant() {
            return this.mobileAppCategoryConstant;
        }

        public Builder setMobileAppCategoryConstant(String mobileAppCategoryConstant) {
            this.mobileAppCategoryConstant = mobileAppCategoryConstant;
            return this;
        }

        private Builder() {
        }

        private Builder(MobileAppCategoryConstantName mobileAppCategoryConstantName) {
            this.mobileAppCategoryConstant = mobileAppCategoryConstantName.mobileAppCategoryConstant;
        }

        public MobileAppCategoryConstantName build() {
            return new MobileAppCategoryConstantName(this);
        }
    }
}

