/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MobileDeviceConstantName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"mobileDeviceConstants/{mobile_device_constant}");
    private volatile Map<String, String> fieldValuesMap;
    private final String mobileDeviceConstant;

    public String getMobileDeviceConstant() {
        return this.mobileDeviceConstant;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private MobileDeviceConstantName(Builder builder) {
        this.mobileDeviceConstant = (String)Preconditions.checkNotNull((Object)builder.getMobileDeviceConstant());
    }

    public static MobileDeviceConstantName of(String mobileDeviceConstant) {
        return MobileDeviceConstantName.newBuilder().setMobileDeviceConstant(mobileDeviceConstant).build();
    }

    public static String format(String mobileDeviceConstant) {
        return MobileDeviceConstantName.newBuilder().setMobileDeviceConstant(mobileDeviceConstant).build().toString();
    }

    public static MobileDeviceConstantName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "MobileDeviceConstantName.parse: formattedString not in valid format");
        return MobileDeviceConstantName.of((String)matchMap.get("mobile_device_constant"));
    }

    public static List<MobileDeviceConstantName> parseList(List<String> formattedStrings) {
        ArrayList<MobileDeviceConstantName> list = new ArrayList<MobileDeviceConstantName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MobileDeviceConstantName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MobileDeviceConstantName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MobileDeviceConstantName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MobileDeviceConstantName mobileDeviceConstantName = this;
            synchronized (mobileDeviceConstantName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"mobileDeviceConstant", (Object)this.mobileDeviceConstant);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"mobile_device_constant", this.mobileDeviceConstant});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MobileDeviceConstantName) {
            MobileDeviceConstantName that = (MobileDeviceConstantName)o;
            return this.mobileDeviceConstant.equals(that.mobileDeviceConstant);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= this.mobileDeviceConstant.hashCode();
    }

    public static class Builder {
        private String mobileDeviceConstant;

        public String getMobileDeviceConstant() {
            return this.mobileDeviceConstant;
        }

        public Builder setMobileDeviceConstant(String mobileDeviceConstant) {
            this.mobileDeviceConstant = mobileDeviceConstant;
            return this;
        }

        private Builder() {
        }

        private Builder(MobileDeviceConstantName mobileDeviceConstantName) {
            this.mobileDeviceConstant = mobileDeviceConstantName.mobileDeviceConstant;
        }

        public MobileDeviceConstantName build() {
            return new MobileDeviceConstantName(this);
        }
    }
}

