/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OfflineUserDataJobName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/offlineUserDataJobs/{offline_user_data_job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String offlineUserDataJob;

    public String getCustomer() {
        return this.customer;
    }

    public String getOfflineUserDataJob() {
        return this.offlineUserDataJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private OfflineUserDataJobName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.offlineUserDataJob = (String)Preconditions.checkNotNull((Object)builder.getOfflineUserDataJob());
    }

    public static OfflineUserDataJobName of(String customer, String offlineUserDataJob) {
        return OfflineUserDataJobName.newBuilder().setCustomer(customer).setOfflineUserDataJob(offlineUserDataJob).build();
    }

    public static String format(String customer, String offlineUserDataJob) {
        return OfflineUserDataJobName.newBuilder().setCustomer(customer).setOfflineUserDataJob(offlineUserDataJob).build().toString();
    }

    public static OfflineUserDataJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "OfflineUserDataJobName.parse: formattedString not in valid format");
        return OfflineUserDataJobName.of((String)matchMap.get("customer"), (String)matchMap.get("offline_user_data_job"));
    }

    public static List<OfflineUserDataJobName> parseList(List<String> formattedStrings) {
        ArrayList<OfflineUserDataJobName> list = new ArrayList<OfflineUserDataJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OfflineUserDataJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OfflineUserDataJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OfflineUserDataJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OfflineUserDataJobName offlineUserDataJobName = this;
            synchronized (offlineUserDataJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"offlineUserDataJob", (Object)this.offlineUserDataJob);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "offline_user_data_job", this.offlineUserDataJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OfflineUserDataJobName) {
            OfflineUserDataJobName that = (OfflineUserDataJobName)o;
            return this.customer.equals(that.customer) && this.offlineUserDataJob.equals(that.offlineUserDataJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.offlineUserDataJob.hashCode();
    }

    public static class Builder {
        private String customer;
        private String offlineUserDataJob;

        public String getCustomer() {
            return this.customer;
        }

        public String getOfflineUserDataJob() {
            return this.offlineUserDataJob;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setOfflineUserDataJob(String offlineUserDataJob) {
            this.offlineUserDataJob = offlineUserDataJob;
            return this;
        }

        private Builder() {
        }

        private Builder(OfflineUserDataJobName offlineUserDataJobName) {
            this.customer = offlineUserDataJobName.customer;
            this.offlineUserDataJob = offlineUserDataJobName.offlineUserDataJob;
        }

        public OfflineUserDataJobName build() {
            return new OfflineUserDataJobName(this);
        }
    }
}

