/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OperatingSystemVersionConstantName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"operatingSystemVersionConstants/{operating_system_version_constant}");
    private volatile Map<String, String> fieldValuesMap;
    private final String operatingSystemVersionConstant;

    public String getOperatingSystemVersionConstant() {
        return this.operatingSystemVersionConstant;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private OperatingSystemVersionConstantName(Builder builder) {
        this.operatingSystemVersionConstant = (String)Preconditions.checkNotNull((Object)builder.getOperatingSystemVersionConstant());
    }

    public static OperatingSystemVersionConstantName of(String operatingSystemVersionConstant) {
        return OperatingSystemVersionConstantName.newBuilder().setOperatingSystemVersionConstant(operatingSystemVersionConstant).build();
    }

    public static String format(String operatingSystemVersionConstant) {
        return OperatingSystemVersionConstantName.newBuilder().setOperatingSystemVersionConstant(operatingSystemVersionConstant).build().toString();
    }

    public static OperatingSystemVersionConstantName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "OperatingSystemVersionConstantName.parse: formattedString not in valid format");
        return OperatingSystemVersionConstantName.of((String)matchMap.get("operating_system_version_constant"));
    }

    public static List<OperatingSystemVersionConstantName> parseList(List<String> formattedStrings) {
        ArrayList<OperatingSystemVersionConstantName> list = new ArrayList<OperatingSystemVersionConstantName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OperatingSystemVersionConstantName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OperatingSystemVersionConstantName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OperatingSystemVersionConstantName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OperatingSystemVersionConstantName operatingSystemVersionConstantName = this;
            synchronized (operatingSystemVersionConstantName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"operatingSystemVersionConstant", (Object)this.operatingSystemVersionConstant);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"operating_system_version_constant", this.operatingSystemVersionConstant});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OperatingSystemVersionConstantName) {
            OperatingSystemVersionConstantName that = (OperatingSystemVersionConstantName)o;
            return this.operatingSystemVersionConstant.equals(that.operatingSystemVersionConstant);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= this.operatingSystemVersionConstant.hashCode();
    }

    public static class Builder {
        private String operatingSystemVersionConstant;

        public String getOperatingSystemVersionConstant() {
            return this.operatingSystemVersionConstant;
        }

        public Builder setOperatingSystemVersionConstant(String operatingSystemVersionConstant) {
            this.operatingSystemVersionConstant = operatingSystemVersionConstant;
            return this;
        }

        private Builder() {
        }

        private Builder(OperatingSystemVersionConstantName operatingSystemVersionConstantName) {
            this.operatingSystemVersionConstant = operatingSystemVersionConstantName.operatingSystemVersionConstant;
        }

        public OperatingSystemVersionConstantName build() {
            return new OperatingSystemVersionConstantName(this);
        }
    }
}

