/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PaidOrganicSearchTermViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/paidOrganicSearchTermViews/{paid_organic_search_term_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String paidOrganicSearchTermView;

    public String getCustomer() {
        return this.customer;
    }

    public String getPaidOrganicSearchTermView() {
        return this.paidOrganicSearchTermView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private PaidOrganicSearchTermViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.paidOrganicSearchTermView = (String)Preconditions.checkNotNull((Object)builder.getPaidOrganicSearchTermView());
    }

    public static PaidOrganicSearchTermViewName of(String customer, String paidOrganicSearchTermView) {
        return PaidOrganicSearchTermViewName.newBuilder().setCustomer(customer).setPaidOrganicSearchTermView(paidOrganicSearchTermView).build();
    }

    public static String format(String customer, String paidOrganicSearchTermView) {
        return PaidOrganicSearchTermViewName.newBuilder().setCustomer(customer).setPaidOrganicSearchTermView(paidOrganicSearchTermView).build().toString();
    }

    public static PaidOrganicSearchTermViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "PaidOrganicSearchTermViewName.parse: formattedString not in valid format");
        return PaidOrganicSearchTermViewName.of((String)matchMap.get("customer"), (String)matchMap.get("paid_organic_search_term_view"));
    }

    public static List<PaidOrganicSearchTermViewName> parseList(List<String> formattedStrings) {
        ArrayList<PaidOrganicSearchTermViewName> list = new ArrayList<PaidOrganicSearchTermViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PaidOrganicSearchTermViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PaidOrganicSearchTermViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PaidOrganicSearchTermViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PaidOrganicSearchTermViewName paidOrganicSearchTermViewName = this;
            synchronized (paidOrganicSearchTermViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"paidOrganicSearchTermView", (Object)this.paidOrganicSearchTermView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "paid_organic_search_term_view", this.paidOrganicSearchTermView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PaidOrganicSearchTermViewName) {
            PaidOrganicSearchTermViewName that = (PaidOrganicSearchTermViewName)o;
            return this.customer.equals(that.customer) && this.paidOrganicSearchTermView.equals(that.paidOrganicSearchTermView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.paidOrganicSearchTermView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String paidOrganicSearchTermView;

        public String getCustomer() {
            return this.customer;
        }

        public String getPaidOrganicSearchTermView() {
            return this.paidOrganicSearchTermView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setPaidOrganicSearchTermView(String paidOrganicSearchTermView) {
            this.paidOrganicSearchTermView = paidOrganicSearchTermView;
            return this;
        }

        private Builder() {
        }

        private Builder(PaidOrganicSearchTermViewName paidOrganicSearchTermViewName) {
            this.customer = paidOrganicSearchTermViewName.customer;
            this.paidOrganicSearchTermView = paidOrganicSearchTermViewName.paidOrganicSearchTermView;
        }

        public PaidOrganicSearchTermViewName build() {
            return new PaidOrganicSearchTermViewName(this);
        }
    }
}

