/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ParentalStatusViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/parentalStatusViews/{parental_status_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String parentalStatusView;

    public String getCustomer() {
        return this.customer;
    }

    public String getParentalStatusView() {
        return this.parentalStatusView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ParentalStatusViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.parentalStatusView = (String)Preconditions.checkNotNull((Object)builder.getParentalStatusView());
    }

    public static ParentalStatusViewName of(String customer, String parentalStatusView) {
        return ParentalStatusViewName.newBuilder().setCustomer(customer).setParentalStatusView(parentalStatusView).build();
    }

    public static String format(String customer, String parentalStatusView) {
        return ParentalStatusViewName.newBuilder().setCustomer(customer).setParentalStatusView(parentalStatusView).build().toString();
    }

    public static ParentalStatusViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ParentalStatusViewName.parse: formattedString not in valid format");
        return ParentalStatusViewName.of((String)matchMap.get("customer"), (String)matchMap.get("parental_status_view"));
    }

    public static List<ParentalStatusViewName> parseList(List<String> formattedStrings) {
        ArrayList<ParentalStatusViewName> list = new ArrayList<ParentalStatusViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ParentalStatusViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ParentalStatusViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ParentalStatusViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ParentalStatusViewName parentalStatusViewName = this;
            synchronized (parentalStatusViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"parentalStatusView", (Object)this.parentalStatusView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "parental_status_view", this.parentalStatusView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ParentalStatusViewName) {
            ParentalStatusViewName that = (ParentalStatusViewName)o;
            return this.customer.equals(that.customer) && this.parentalStatusView.equals(that.parentalStatusView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.parentalStatusView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String parentalStatusView;

        public String getCustomer() {
            return this.customer;
        }

        public String getParentalStatusView() {
            return this.parentalStatusView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setParentalStatusView(String parentalStatusView) {
            this.parentalStatusView = parentalStatusView;
            return this;
        }

        private Builder() {
        }

        private Builder(ParentalStatusViewName parentalStatusViewName) {
            this.customer = parentalStatusViewName.customer;
            this.parentalStatusView = parentalStatusViewName.parentalStatusView;
        }

        public ParentalStatusViewName build() {
            return new ParentalStatusViewName(this);
        }
    }
}

