/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PaymentsAccountName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/paymentsAccounts/{payments_account}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String paymentsAccount;

    public String getCustomer() {
        return this.customer;
    }

    public String getPaymentsAccount() {
        return this.paymentsAccount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private PaymentsAccountName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.paymentsAccount = (String)Preconditions.checkNotNull((Object)builder.getPaymentsAccount());
    }

    public static PaymentsAccountName of(String customer, String paymentsAccount) {
        return PaymentsAccountName.newBuilder().setCustomer(customer).setPaymentsAccount(paymentsAccount).build();
    }

    public static String format(String customer, String paymentsAccount) {
        return PaymentsAccountName.newBuilder().setCustomer(customer).setPaymentsAccount(paymentsAccount).build().toString();
    }

    public static PaymentsAccountName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "PaymentsAccountName.parse: formattedString not in valid format");
        return PaymentsAccountName.of((String)matchMap.get("customer"), (String)matchMap.get("payments_account"));
    }

    public static List<PaymentsAccountName> parseList(List<String> formattedStrings) {
        ArrayList<PaymentsAccountName> list = new ArrayList<PaymentsAccountName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PaymentsAccountName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PaymentsAccountName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PaymentsAccountName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PaymentsAccountName paymentsAccountName = this;
            synchronized (paymentsAccountName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"paymentsAccount", (Object)this.paymentsAccount);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "payments_account", this.paymentsAccount});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PaymentsAccountName) {
            PaymentsAccountName that = (PaymentsAccountName)o;
            return this.customer.equals(that.customer) && this.paymentsAccount.equals(that.paymentsAccount);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.paymentsAccount.hashCode();
    }

    public static class Builder {
        private String customer;
        private String paymentsAccount;

        public String getCustomer() {
            return this.customer;
        }

        public String getPaymentsAccount() {
            return this.paymentsAccount;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setPaymentsAccount(String paymentsAccount) {
            this.paymentsAccount = paymentsAccount;
            return this;
        }

        private Builder() {
        }

        private Builder(PaymentsAccountName paymentsAccountName) {
            this.customer = paymentsAccountName.customer;
            this.paymentsAccount = paymentsAccountName.paymentsAccount;
        }

        public PaymentsAccountName build() {
            return new PaymentsAccountName(this);
        }
    }
}

