/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProductBiddingCategoryConstantName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"productBiddingCategoryConstants/{product_bidding_category_constant}");
    private volatile Map<String, String> fieldValuesMap;
    private final String productBiddingCategoryConstant;

    public String getProductBiddingCategoryConstant() {
        return this.productBiddingCategoryConstant;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProductBiddingCategoryConstantName(Builder builder) {
        this.productBiddingCategoryConstant = (String)Preconditions.checkNotNull((Object)builder.getProductBiddingCategoryConstant());
    }

    public static ProductBiddingCategoryConstantName of(String productBiddingCategoryConstant) {
        return ProductBiddingCategoryConstantName.newBuilder().setProductBiddingCategoryConstant(productBiddingCategoryConstant).build();
    }

    public static String format(String productBiddingCategoryConstant) {
        return ProductBiddingCategoryConstantName.newBuilder().setProductBiddingCategoryConstant(productBiddingCategoryConstant).build().toString();
    }

    public static ProductBiddingCategoryConstantName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProductBiddingCategoryConstantName.parse: formattedString not in valid format");
        return ProductBiddingCategoryConstantName.of((String)matchMap.get("product_bidding_category_constant"));
    }

    public static List<ProductBiddingCategoryConstantName> parseList(List<String> formattedStrings) {
        ArrayList<ProductBiddingCategoryConstantName> list = new ArrayList<ProductBiddingCategoryConstantName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProductBiddingCategoryConstantName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProductBiddingCategoryConstantName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProductBiddingCategoryConstantName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProductBiddingCategoryConstantName productBiddingCategoryConstantName = this;
            synchronized (productBiddingCategoryConstantName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"productBiddingCategoryConstant", (Object)this.productBiddingCategoryConstant);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"product_bidding_category_constant", this.productBiddingCategoryConstant});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProductBiddingCategoryConstantName) {
            ProductBiddingCategoryConstantName that = (ProductBiddingCategoryConstantName)o;
            return this.productBiddingCategoryConstant.equals(that.productBiddingCategoryConstant);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= this.productBiddingCategoryConstant.hashCode();
    }

    public static class Builder {
        private String productBiddingCategoryConstant;

        public String getProductBiddingCategoryConstant() {
            return this.productBiddingCategoryConstant;
        }

        public Builder setProductBiddingCategoryConstant(String productBiddingCategoryConstant) {
            this.productBiddingCategoryConstant = productBiddingCategoryConstant;
            return this;
        }

        private Builder() {
        }

        private Builder(ProductBiddingCategoryConstantName productBiddingCategoryConstantName) {
            this.productBiddingCategoryConstant = productBiddingCategoryConstantName.productBiddingCategoryConstant;
        }

        public ProductBiddingCategoryConstantName build() {
            return new ProductBiddingCategoryConstantName(this);
        }
    }
}

