/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProductGroupViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/productGroupViews/{product_group_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String productGroupView;

    public String getCustomer() {
        return this.customer;
    }

    public String getProductGroupView() {
        return this.productGroupView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProductGroupViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.productGroupView = (String)Preconditions.checkNotNull((Object)builder.getProductGroupView());
    }

    public static ProductGroupViewName of(String customer, String productGroupView) {
        return ProductGroupViewName.newBuilder().setCustomer(customer).setProductGroupView(productGroupView).build();
    }

    public static String format(String customer, String productGroupView) {
        return ProductGroupViewName.newBuilder().setCustomer(customer).setProductGroupView(productGroupView).build().toString();
    }

    public static ProductGroupViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProductGroupViewName.parse: formattedString not in valid format");
        return ProductGroupViewName.of((String)matchMap.get("customer"), (String)matchMap.get("product_group_view"));
    }

    public static List<ProductGroupViewName> parseList(List<String> formattedStrings) {
        ArrayList<ProductGroupViewName> list = new ArrayList<ProductGroupViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProductGroupViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProductGroupViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProductGroupViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProductGroupViewName productGroupViewName = this;
            synchronized (productGroupViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"productGroupView", (Object)this.productGroupView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "product_group_view", this.productGroupView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProductGroupViewName) {
            ProductGroupViewName that = (ProductGroupViewName)o;
            return this.customer.equals(that.customer) && this.productGroupView.equals(that.productGroupView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.productGroupView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String productGroupView;

        public String getCustomer() {
            return this.customer;
        }

        public String getProductGroupView() {
            return this.productGroupView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setProductGroupView(String productGroupView) {
            this.productGroupView = productGroupView;
            return this;
        }

        private Builder() {
        }

        private Builder(ProductGroupViewName productGroupViewName) {
            this.customer = productGroupViewName.customer;
            this.productGroupView = productGroupViewName.productGroupView;
        }

        public ProductGroupViewName build() {
            return new ProductGroupViewName(this);
        }
    }
}

