/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RecommendationName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/recommendations/{recommendation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String recommendation;

    public String getCustomer() {
        return this.customer;
    }

    public String getRecommendation() {
        return this.recommendation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private RecommendationName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.recommendation = (String)Preconditions.checkNotNull((Object)builder.getRecommendation());
    }

    public static RecommendationName of(String customer, String recommendation) {
        return RecommendationName.newBuilder().setCustomer(customer).setRecommendation(recommendation).build();
    }

    public static String format(String customer, String recommendation) {
        return RecommendationName.newBuilder().setCustomer(customer).setRecommendation(recommendation).build().toString();
    }

    public static RecommendationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "RecommendationName.parse: formattedString not in valid format");
        return RecommendationName.of((String)matchMap.get("customer"), (String)matchMap.get("recommendation"));
    }

    public static List<RecommendationName> parseList(List<String> formattedStrings) {
        ArrayList<RecommendationName> list = new ArrayList<RecommendationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RecommendationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RecommendationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RecommendationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RecommendationName recommendationName = this;
            synchronized (recommendationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"recommendation", (Object)this.recommendation);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "recommendation", this.recommendation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RecommendationName) {
            RecommendationName that = (RecommendationName)o;
            return this.customer.equals(that.customer) && this.recommendation.equals(that.recommendation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.recommendation.hashCode();
    }

    public static class Builder {
        private String customer;
        private String recommendation;

        public String getCustomer() {
            return this.customer;
        }

        public String getRecommendation() {
            return this.recommendation;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setRecommendation(String recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        private Builder() {
        }

        private Builder(RecommendationName recommendationName) {
            this.customer = recommendationName.customer;
            this.recommendation = recommendationName.recommendation;
        }

        public RecommendationName build() {
            return new RecommendationName(this);
        }
    }
}

