/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RemarketingActionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/remarketingActions/{remarketing_action}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String remarketingAction;

    public String getCustomer() {
        return this.customer;
    }

    public String getRemarketingAction() {
        return this.remarketingAction;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private RemarketingActionName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.remarketingAction = (String)Preconditions.checkNotNull((Object)builder.getRemarketingAction());
    }

    public static RemarketingActionName of(String customer, String remarketingAction) {
        return RemarketingActionName.newBuilder().setCustomer(customer).setRemarketingAction(remarketingAction).build();
    }

    public static String format(String customer, String remarketingAction) {
        return RemarketingActionName.newBuilder().setCustomer(customer).setRemarketingAction(remarketingAction).build().toString();
    }

    public static RemarketingActionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "RemarketingActionName.parse: formattedString not in valid format");
        return RemarketingActionName.of((String)matchMap.get("customer"), (String)matchMap.get("remarketing_action"));
    }

    public static List<RemarketingActionName> parseList(List<String> formattedStrings) {
        ArrayList<RemarketingActionName> list = new ArrayList<RemarketingActionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RemarketingActionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RemarketingActionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RemarketingActionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RemarketingActionName remarketingActionName = this;
            synchronized (remarketingActionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"remarketingAction", (Object)this.remarketingAction);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "remarketing_action", this.remarketingAction});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RemarketingActionName) {
            RemarketingActionName that = (RemarketingActionName)o;
            return this.customer.equals(that.customer) && this.remarketingAction.equals(that.remarketingAction);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.remarketingAction.hashCode();
    }

    public static class Builder {
        private String customer;
        private String remarketingAction;

        public String getCustomer() {
            return this.customer;
        }

        public String getRemarketingAction() {
            return this.remarketingAction;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setRemarketingAction(String remarketingAction) {
            this.remarketingAction = remarketingAction;
            return this;
        }

        private Builder() {
        }

        private Builder(RemarketingActionName remarketingActionName) {
            this.customer = remarketingActionName.customer;
            this.remarketingAction = remarketingActionName.remarketingAction;
        }

        public RemarketingActionName build() {
            return new RemarketingActionName(this);
        }
    }
}

