/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.ads.googleads.v5.resources.RemarketingAction;
import com.google.ads.googleads.v5.services.GetRemarketingActionRequest;
import com.google.ads.googleads.v5.services.MutateRemarketingActionsRequest;
import com.google.ads.googleads.v5.services.MutateRemarketingActionsResponse;
import com.google.ads.googleads.v5.services.RemarketingActionName;
import com.google.ads.googleads.v5.services.RemarketingActionOperation;
import com.google.ads.googleads.v5.services.RemarketingActionServiceSettings;
import com.google.ads.googleads.v5.services.stub.RemarketingActionServiceStub;
import com.google.ads.googleads.v5.services.stub.RemarketingActionServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RemarketingActionServiceClient
implements BackgroundResource {
    private final RemarketingActionServiceSettings settings;
    private final RemarketingActionServiceStub stub;

    public static final RemarketingActionServiceClient create() throws IOException {
        return RemarketingActionServiceClient.create(RemarketingActionServiceSettings.newBuilder().build());
    }

    public static final RemarketingActionServiceClient create(RemarketingActionServiceSettings settings) throws IOException {
        return new RemarketingActionServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RemarketingActionServiceClient create(RemarketingActionServiceStub stub) {
        return new RemarketingActionServiceClient(stub);
    }

    protected RemarketingActionServiceClient(RemarketingActionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RemarketingActionServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RemarketingActionServiceClient(RemarketingActionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RemarketingActionServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RemarketingActionServiceStub getStub() {
        return this.stub;
    }

    public final RemarketingAction getRemarketingAction(RemarketingActionName resourceName) {
        GetRemarketingActionRequest request = GetRemarketingActionRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getRemarketingAction(request);
    }

    public final RemarketingAction getRemarketingAction(String resourceName) {
        GetRemarketingActionRequest request = GetRemarketingActionRequest.newBuilder().setResourceName(resourceName).build();
        return this.getRemarketingAction(request);
    }

    public final RemarketingAction getRemarketingAction(GetRemarketingActionRequest request) {
        return (RemarketingAction)this.getRemarketingActionCallable().call((Object)request);
    }

    public final UnaryCallable<GetRemarketingActionRequest, RemarketingAction> getRemarketingActionCallable() {
        return this.stub.getRemarketingActionCallable();
    }

    public final MutateRemarketingActionsResponse mutateRemarketingActions(String customerId, List<RemarketingActionOperation> operations) {
        MutateRemarketingActionsRequest request = MutateRemarketingActionsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateRemarketingActions(request);
    }

    public final MutateRemarketingActionsResponse mutateRemarketingActions(MutateRemarketingActionsRequest request) {
        return (MutateRemarketingActionsResponse)this.mutateRemarketingActionsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateRemarketingActionsRequest, MutateRemarketingActionsResponse> mutateRemarketingActionsCallable() {
        return this.stub.mutateRemarketingActionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

