/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SearchTermViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/searchTermViews/{search_term_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String searchTermView;

    public String getCustomer() {
        return this.customer;
    }

    public String getSearchTermView() {
        return this.searchTermView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private SearchTermViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.searchTermView = (String)Preconditions.checkNotNull((Object)builder.getSearchTermView());
    }

    public static SearchTermViewName of(String customer, String searchTermView) {
        return SearchTermViewName.newBuilder().setCustomer(customer).setSearchTermView(searchTermView).build();
    }

    public static String format(String customer, String searchTermView) {
        return SearchTermViewName.newBuilder().setCustomer(customer).setSearchTermView(searchTermView).build().toString();
    }

    public static SearchTermViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "SearchTermViewName.parse: formattedString not in valid format");
        return SearchTermViewName.of((String)matchMap.get("customer"), (String)matchMap.get("search_term_view"));
    }

    public static List<SearchTermViewName> parseList(List<String> formattedStrings) {
        ArrayList<SearchTermViewName> list = new ArrayList<SearchTermViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SearchTermViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SearchTermViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SearchTermViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SearchTermViewName searchTermViewName = this;
            synchronized (searchTermViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"searchTermView", (Object)this.searchTermView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "search_term_view", this.searchTermView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SearchTermViewName) {
            SearchTermViewName that = (SearchTermViewName)o;
            return this.customer.equals(that.customer) && this.searchTermView.equals(that.searchTermView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.searchTermView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String searchTermView;

        public String getCustomer() {
            return this.customer;
        }

        public String getSearchTermView() {
            return this.searchTermView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setSearchTermView(String searchTermView) {
            this.searchTermView = searchTermView;
            return this;
        }

        private Builder() {
        }

        private Builder(SearchTermViewName searchTermViewName) {
            this.customer = searchTermViewName.customer;
            this.searchTermView = searchTermViewName.searchTermView;
        }

        public SearchTermViewName build() {
            return new SearchTermViewName(this);
        }
    }
}

