/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SharedCriterionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/sharedCriteria/{shared_criterion}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String sharedCriterion;

    public String getCustomer() {
        return this.customer;
    }

    public String getSharedCriterion() {
        return this.sharedCriterion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private SharedCriterionName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.sharedCriterion = (String)Preconditions.checkNotNull((Object)builder.getSharedCriterion());
    }

    public static SharedCriterionName of(String customer, String sharedCriterion) {
        return SharedCriterionName.newBuilder().setCustomer(customer).setSharedCriterion(sharedCriterion).build();
    }

    public static String format(String customer, String sharedCriterion) {
        return SharedCriterionName.newBuilder().setCustomer(customer).setSharedCriterion(sharedCriterion).build().toString();
    }

    public static SharedCriterionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "SharedCriterionName.parse: formattedString not in valid format");
        return SharedCriterionName.of((String)matchMap.get("customer"), (String)matchMap.get("shared_criterion"));
    }

    public static List<SharedCriterionName> parseList(List<String> formattedStrings) {
        ArrayList<SharedCriterionName> list = new ArrayList<SharedCriterionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SharedCriterionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SharedCriterionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SharedCriterionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SharedCriterionName sharedCriterionName = this;
            synchronized (sharedCriterionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"sharedCriterion", (Object)this.sharedCriterion);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "shared_criterion", this.sharedCriterion});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SharedCriterionName) {
            SharedCriterionName that = (SharedCriterionName)o;
            return this.customer.equals(that.customer) && this.sharedCriterion.equals(that.sharedCriterion);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.sharedCriterion.hashCode();
    }

    public static class Builder {
        private String customer;
        private String sharedCriterion;

        public String getCustomer() {
            return this.customer;
        }

        public String getSharedCriterion() {
            return this.sharedCriterion;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setSharedCriterion(String sharedCriterion) {
            this.sharedCriterion = sharedCriterion;
            return this;
        }

        private Builder() {
        }

        private Builder(SharedCriterionName sharedCriterionName) {
            this.customer = sharedCriterionName.customer;
            this.sharedCriterion = sharedCriterionName.sharedCriterion;
        }

        public SharedCriterionName build() {
            return new SharedCriterionName(this);
        }
    }
}

