/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SharedSetName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/sharedSets/{shared_set}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String sharedSet;

    public String getCustomer() {
        return this.customer;
    }

    public String getSharedSet() {
        return this.sharedSet;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private SharedSetName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.sharedSet = (String)Preconditions.checkNotNull((Object)builder.getSharedSet());
    }

    public static SharedSetName of(String customer, String sharedSet) {
        return SharedSetName.newBuilder().setCustomer(customer).setSharedSet(sharedSet).build();
    }

    public static String format(String customer, String sharedSet) {
        return SharedSetName.newBuilder().setCustomer(customer).setSharedSet(sharedSet).build().toString();
    }

    public static SharedSetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "SharedSetName.parse: formattedString not in valid format");
        return SharedSetName.of((String)matchMap.get("customer"), (String)matchMap.get("shared_set"));
    }

    public static List<SharedSetName> parseList(List<String> formattedStrings) {
        ArrayList<SharedSetName> list = new ArrayList<SharedSetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SharedSetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SharedSetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SharedSetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SharedSetName sharedSetName = this;
            synchronized (sharedSetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"sharedSet", (Object)this.sharedSet);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "shared_set", this.sharedSet});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SharedSetName) {
            SharedSetName that = (SharedSetName)o;
            return this.customer.equals(that.customer) && this.sharedSet.equals(that.sharedSet);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.sharedSet.hashCode();
    }

    public static class Builder {
        private String customer;
        private String sharedSet;

        public String getCustomer() {
            return this.customer;
        }

        public String getSharedSet() {
            return this.sharedSet;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setSharedSet(String sharedSet) {
            this.sharedSet = sharedSet;
            return this;
        }

        private Builder() {
        }

        private Builder(SharedSetName sharedSetName) {
            this.customer = sharedSetName.customer;
            this.sharedSet = sharedSetName.sharedSet;
        }

        public SharedSetName build() {
            return new SharedSetName(this);
        }
    }
}

