/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ShoppingPerformanceViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/shoppingPerformanceView");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;

    public String getCustomer() {
        return this.customer;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ShoppingPerformanceViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
    }

    public static ShoppingPerformanceViewName of(String customer) {
        return ShoppingPerformanceViewName.newBuilder().setCustomer(customer).build();
    }

    public static String format(String customer) {
        return ShoppingPerformanceViewName.newBuilder().setCustomer(customer).build().toString();
    }

    public static ShoppingPerformanceViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ShoppingPerformanceViewName.parse: formattedString not in valid format");
        return ShoppingPerformanceViewName.of((String)matchMap.get("customer"));
    }

    public static List<ShoppingPerformanceViewName> parseList(List<String> formattedStrings) {
        ArrayList<ShoppingPerformanceViewName> list = new ArrayList<ShoppingPerformanceViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ShoppingPerformanceViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ShoppingPerformanceViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ShoppingPerformanceViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ShoppingPerformanceViewName shoppingPerformanceViewName = this;
            synchronized (shoppingPerformanceViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ShoppingPerformanceViewName) {
            ShoppingPerformanceViewName that = (ShoppingPerformanceViewName)o;
            return this.customer.equals(that.customer);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= this.customer.hashCode();
    }

    public static class Builder {
        private String customer;

        public String getCustomer() {
            return this.customer;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        private Builder() {
        }

        private Builder(ShoppingPerformanceViewName shoppingPerformanceViewName) {
            this.customer = shoppingPerformanceViewName.customer;
        }

        public ShoppingPerformanceViewName build() {
            return new ShoppingPerformanceViewName(this);
        }
    }
}

