/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ThirdPartyAppAnalyticsLinkName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/thirdPartyAppAnalyticsLinks/{third_party_app_analytics_link}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String thirdPartyAppAnalyticsLink;

    public String getCustomer() {
        return this.customer;
    }

    public String getThirdPartyAppAnalyticsLink() {
        return this.thirdPartyAppAnalyticsLink;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ThirdPartyAppAnalyticsLinkName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.thirdPartyAppAnalyticsLink = (String)Preconditions.checkNotNull((Object)builder.getThirdPartyAppAnalyticsLink());
    }

    public static ThirdPartyAppAnalyticsLinkName of(String customer, String thirdPartyAppAnalyticsLink) {
        return ThirdPartyAppAnalyticsLinkName.newBuilder().setCustomer(customer).setThirdPartyAppAnalyticsLink(thirdPartyAppAnalyticsLink).build();
    }

    public static String format(String customer, String thirdPartyAppAnalyticsLink) {
        return ThirdPartyAppAnalyticsLinkName.newBuilder().setCustomer(customer).setThirdPartyAppAnalyticsLink(thirdPartyAppAnalyticsLink).build().toString();
    }

    public static ThirdPartyAppAnalyticsLinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ThirdPartyAppAnalyticsLinkName.parse: formattedString not in valid format");
        return ThirdPartyAppAnalyticsLinkName.of((String)matchMap.get("customer"), (String)matchMap.get("third_party_app_analytics_link"));
    }

    public static List<ThirdPartyAppAnalyticsLinkName> parseList(List<String> formattedStrings) {
        ArrayList<ThirdPartyAppAnalyticsLinkName> list = new ArrayList<ThirdPartyAppAnalyticsLinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ThirdPartyAppAnalyticsLinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ThirdPartyAppAnalyticsLinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ThirdPartyAppAnalyticsLinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ThirdPartyAppAnalyticsLinkName thirdPartyAppAnalyticsLinkName = this;
            synchronized (thirdPartyAppAnalyticsLinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"thirdPartyAppAnalyticsLink", (Object)this.thirdPartyAppAnalyticsLink);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "third_party_app_analytics_link", this.thirdPartyAppAnalyticsLink});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ThirdPartyAppAnalyticsLinkName) {
            ThirdPartyAppAnalyticsLinkName that = (ThirdPartyAppAnalyticsLinkName)o;
            return this.customer.equals(that.customer) && this.thirdPartyAppAnalyticsLink.equals(that.thirdPartyAppAnalyticsLink);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.thirdPartyAppAnalyticsLink.hashCode();
    }

    public static class Builder {
        private String customer;
        private String thirdPartyAppAnalyticsLink;

        public String getCustomer() {
            return this.customer;
        }

        public String getThirdPartyAppAnalyticsLink() {
            return this.thirdPartyAppAnalyticsLink;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setThirdPartyAppAnalyticsLink(String thirdPartyAppAnalyticsLink) {
            this.thirdPartyAppAnalyticsLink = thirdPartyAppAnalyticsLink;
            return this;
        }

        private Builder() {
        }

        private Builder(ThirdPartyAppAnalyticsLinkName thirdPartyAppAnalyticsLinkName) {
            this.customer = thirdPartyAppAnalyticsLinkName.customer;
            this.thirdPartyAppAnalyticsLink = thirdPartyAppAnalyticsLinkName.thirdPartyAppAnalyticsLink;
        }

        public ThirdPartyAppAnalyticsLinkName build() {
            return new ThirdPartyAppAnalyticsLinkName(this);
        }
    }
}

