/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TopicConstantName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"topicConstants/{topic_constant}");
    private volatile Map<String, String> fieldValuesMap;
    private final String topicConstant;

    public String getTopicConstant() {
        return this.topicConstant;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private TopicConstantName(Builder builder) {
        this.topicConstant = (String)Preconditions.checkNotNull((Object)builder.getTopicConstant());
    }

    public static TopicConstantName of(String topicConstant) {
        return TopicConstantName.newBuilder().setTopicConstant(topicConstant).build();
    }

    public static String format(String topicConstant) {
        return TopicConstantName.newBuilder().setTopicConstant(topicConstant).build().toString();
    }

    public static TopicConstantName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "TopicConstantName.parse: formattedString not in valid format");
        return TopicConstantName.of((String)matchMap.get("topic_constant"));
    }

    public static List<TopicConstantName> parseList(List<String> formattedStrings) {
        ArrayList<TopicConstantName> list = new ArrayList<TopicConstantName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TopicConstantName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TopicConstantName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TopicConstantName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TopicConstantName topicConstantName = this;
            synchronized (topicConstantName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"topicConstant", (Object)this.topicConstant);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"topic_constant", this.topicConstant});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TopicConstantName) {
            TopicConstantName that = (TopicConstantName)o;
            return this.topicConstant.equals(that.topicConstant);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= this.topicConstant.hashCode();
    }

    public static class Builder {
        private String topicConstant;

        public String getTopicConstant() {
            return this.topicConstant;
        }

        public Builder setTopicConstant(String topicConstant) {
            this.topicConstant = topicConstant;
            return this;
        }

        private Builder() {
        }

        private Builder(TopicConstantName topicConstantName) {
            this.topicConstant = topicConstantName.topicConstant;
        }

        public TopicConstantName build() {
            return new TopicConstantName(this);
        }
    }
}

