/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TopicViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/topicViews/{topic_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String topicView;

    public String getCustomer() {
        return this.customer;
    }

    public String getTopicView() {
        return this.topicView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private TopicViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.topicView = (String)Preconditions.checkNotNull((Object)builder.getTopicView());
    }

    public static TopicViewName of(String customer, String topicView) {
        return TopicViewName.newBuilder().setCustomer(customer).setTopicView(topicView).build();
    }

    public static String format(String customer, String topicView) {
        return TopicViewName.newBuilder().setCustomer(customer).setTopicView(topicView).build().toString();
    }

    public static TopicViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "TopicViewName.parse: formattedString not in valid format");
        return TopicViewName.of((String)matchMap.get("customer"), (String)matchMap.get("topic_view"));
    }

    public static List<TopicViewName> parseList(List<String> formattedStrings) {
        ArrayList<TopicViewName> list = new ArrayList<TopicViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TopicViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TopicViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TopicViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TopicViewName topicViewName = this;
            synchronized (topicViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"topicView", (Object)this.topicView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "topic_view", this.topicView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TopicViewName) {
            TopicViewName that = (TopicViewName)o;
            return this.customer.equals(that.customer) && this.topicView.equals(that.topicView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.topicView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String topicView;

        public String getCustomer() {
            return this.customer;
        }

        public String getTopicView() {
            return this.topicView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setTopicView(String topicView) {
            this.topicView = topicView;
            return this;
        }

        private Builder() {
        }

        private Builder(TopicViewName topicViewName) {
            this.customer = topicViewName.customer;
            this.topicView = topicViewName.topicView;
        }

        public TopicViewName build() {
            return new TopicViewName(this);
        }
    }
}

