/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UserInterestName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/userInterests/{user_interest}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String userInterest;

    public String getCustomer() {
        return this.customer;
    }

    public String getUserInterest() {
        return this.userInterest;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private UserInterestName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.userInterest = (String)Preconditions.checkNotNull((Object)builder.getUserInterest());
    }

    public static UserInterestName of(String customer, String userInterest) {
        return UserInterestName.newBuilder().setCustomer(customer).setUserInterest(userInterest).build();
    }

    public static String format(String customer, String userInterest) {
        return UserInterestName.newBuilder().setCustomer(customer).setUserInterest(userInterest).build().toString();
    }

    public static UserInterestName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "UserInterestName.parse: formattedString not in valid format");
        return UserInterestName.of((String)matchMap.get("customer"), (String)matchMap.get("user_interest"));
    }

    public static List<UserInterestName> parseList(List<String> formattedStrings) {
        ArrayList<UserInterestName> list = new ArrayList<UserInterestName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UserInterestName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UserInterestName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UserInterestName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            UserInterestName userInterestName = this;
            synchronized (userInterestName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"userInterest", (Object)this.userInterest);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "user_interest", this.userInterest});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UserInterestName) {
            UserInterestName that = (UserInterestName)o;
            return this.customer.equals(that.customer) && this.userInterest.equals(that.userInterest);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.userInterest.hashCode();
    }

    public static class Builder {
        private String customer;
        private String userInterest;

        public String getCustomer() {
            return this.customer;
        }

        public String getUserInterest() {
            return this.userInterest;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setUserInterest(String userInterest) {
            this.userInterest = userInterest;
            return this;
        }

        private Builder() {
        }

        private Builder(UserInterestName userInterestName) {
            this.customer = userInterestName.customer;
            this.userInterest = userInterestName.userInterest;
        }

        public UserInterestName build() {
            return new UserInterestName(this);
        }
    }
}

