/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.ads.googleads.v5.resources.UserInterest;
import com.google.ads.googleads.v5.services.GetUserInterestRequest;
import com.google.ads.googleads.v5.services.UserInterestName;
import com.google.ads.googleads.v5.services.UserInterestServiceSettings;
import com.google.ads.googleads.v5.services.stub.UserInterestServiceStub;
import com.google.ads.googleads.v5.services.stub.UserInterestServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class UserInterestServiceClient
implements BackgroundResource {
    private final UserInterestServiceSettings settings;
    private final UserInterestServiceStub stub;

    public static final UserInterestServiceClient create() throws IOException {
        return UserInterestServiceClient.create(UserInterestServiceSettings.newBuilder().build());
    }

    public static final UserInterestServiceClient create(UserInterestServiceSettings settings) throws IOException {
        return new UserInterestServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final UserInterestServiceClient create(UserInterestServiceStub stub) {
        return new UserInterestServiceClient(stub);
    }

    protected UserInterestServiceClient(UserInterestServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((UserInterestServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected UserInterestServiceClient(UserInterestServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final UserInterestServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public UserInterestServiceStub getStub() {
        return this.stub;
    }

    public final UserInterest getUserInterest(UserInterestName resourceName) {
        GetUserInterestRequest request = GetUserInterestRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getUserInterest(request);
    }

    public final UserInterest getUserInterest(String resourceName) {
        GetUserInterestRequest request = GetUserInterestRequest.newBuilder().setResourceName(resourceName).build();
        return this.getUserInterest(request);
    }

    public final UserInterest getUserInterest(GetUserInterestRequest request) {
        return (UserInterest)this.getUserInterestCallable().call((Object)request);
    }

    public final UnaryCallable<GetUserInterestRequest, UserInterest> getUserInterestCallable() {
        return this.stub.getUserInterestCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

