/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UserListName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/userLists/{user_list}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String userList;

    public String getCustomer() {
        return this.customer;
    }

    public String getUserList() {
        return this.userList;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private UserListName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.userList = (String)Preconditions.checkNotNull((Object)builder.getUserList());
    }

    public static UserListName of(String customer, String userList) {
        return UserListName.newBuilder().setCustomer(customer).setUserList(userList).build();
    }

    public static String format(String customer, String userList) {
        return UserListName.newBuilder().setCustomer(customer).setUserList(userList).build().toString();
    }

    public static UserListName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "UserListName.parse: formattedString not in valid format");
        return UserListName.of((String)matchMap.get("customer"), (String)matchMap.get("user_list"));
    }

    public static List<UserListName> parseList(List<String> formattedStrings) {
        ArrayList<UserListName> list = new ArrayList<UserListName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UserListName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UserListName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UserListName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            UserListName userListName = this;
            synchronized (userListName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"userList", (Object)this.userList);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "user_list", this.userList});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UserListName) {
            UserListName that = (UserListName)o;
            return this.customer.equals(that.customer) && this.userList.equals(that.userList);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.userList.hashCode();
    }

    public static class Builder {
        private String customer;
        private String userList;

        public String getCustomer() {
            return this.customer;
        }

        public String getUserList() {
            return this.userList;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setUserList(String userList) {
            this.userList = userList;
            return this;
        }

        private Builder() {
        }

        private Builder(UserListName userListName) {
            this.customer = userListName.customer;
            this.userList = userListName.userList;
        }

        public UserListName build() {
            return new UserListName(this);
        }
    }
}

