/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UserLocationViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/userLocationViews/{user_location_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String userLocationView;

    public String getCustomer() {
        return this.customer;
    }

    public String getUserLocationView() {
        return this.userLocationView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private UserLocationViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.userLocationView = (String)Preconditions.checkNotNull((Object)builder.getUserLocationView());
    }

    public static UserLocationViewName of(String customer, String userLocationView) {
        return UserLocationViewName.newBuilder().setCustomer(customer).setUserLocationView(userLocationView).build();
    }

    public static String format(String customer, String userLocationView) {
        return UserLocationViewName.newBuilder().setCustomer(customer).setUserLocationView(userLocationView).build().toString();
    }

    public static UserLocationViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "UserLocationViewName.parse: formattedString not in valid format");
        return UserLocationViewName.of((String)matchMap.get("customer"), (String)matchMap.get("user_location_view"));
    }

    public static List<UserLocationViewName> parseList(List<String> formattedStrings) {
        ArrayList<UserLocationViewName> list = new ArrayList<UserLocationViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UserLocationViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UserLocationViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UserLocationViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            UserLocationViewName userLocationViewName = this;
            synchronized (userLocationViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"userLocationView", (Object)this.userLocationView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "user_location_view", this.userLocationView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UserLocationViewName) {
            UserLocationViewName that = (UserLocationViewName)o;
            return this.customer.equals(that.customer) && this.userLocationView.equals(that.userLocationView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.userLocationView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String userLocationView;

        public String getCustomer() {
            return this.customer;
        }

        public String getUserLocationView() {
            return this.userLocationView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setUserLocationView(String userLocationView) {
            this.userLocationView = userLocationView;
            return this;
        }

        private Builder() {
        }

        private Builder(UserLocationViewName userLocationViewName) {
            this.customer = userLocationViewName.customer;
            this.userLocationView = userLocationViewName.userLocationView;
        }

        public UserLocationViewName build() {
            return new UserLocationViewName(this);
        }
    }
}

