/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VideoName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/videos/{video}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String video;

    public String getCustomer() {
        return this.customer;
    }

    public String getVideo() {
        return this.video;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private VideoName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.video = (String)Preconditions.checkNotNull((Object)builder.getVideo());
    }

    public static VideoName of(String customer, String video) {
        return VideoName.newBuilder().setCustomer(customer).setVideo(video).build();
    }

    public static String format(String customer, String video) {
        return VideoName.newBuilder().setCustomer(customer).setVideo(video).build().toString();
    }

    public static VideoName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "VideoName.parse: formattedString not in valid format");
        return VideoName.of((String)matchMap.get("customer"), (String)matchMap.get("video"));
    }

    public static List<VideoName> parseList(List<String> formattedStrings) {
        ArrayList<VideoName> list = new ArrayList<VideoName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(VideoName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<VideoName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (VideoName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            VideoName videoName = this;
            synchronized (videoName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"video", (Object)this.video);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "video", this.video});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof VideoName) {
            VideoName that = (VideoName)o;
            return this.customer.equals(that.customer) && this.video.equals(that.video);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.video.hashCode();
    }

    public static class Builder {
        private String customer;
        private String video;

        public String getCustomer() {
            return this.customer;
        }

        public String getVideo() {
            return this.video;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setVideo(String video) {
            this.video = video;
            return this;
        }

        private Builder() {
        }

        private Builder(VideoName videoName) {
            this.customer = videoName.customer;
            this.video = videoName.video;
        }

        public VideoName build() {
            return new VideoName(this);
        }
    }
}

