/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services.stub;

import com.google.ads.googleads.v5.resources.CampaignDraft;
import com.google.ads.googleads.v5.services.CampaignDraftServiceClient;
import com.google.ads.googleads.v5.services.GetCampaignDraftRequest;
import com.google.ads.googleads.v5.services.ListCampaignDraftAsyncErrorsRequest;
import com.google.ads.googleads.v5.services.ListCampaignDraftAsyncErrorsResponse;
import com.google.ads.googleads.v5.services.MutateCampaignDraftsRequest;
import com.google.ads.googleads.v5.services.MutateCampaignDraftsResponse;
import com.google.ads.googleads.v5.services.PromoteCampaignDraftRequest;
import com.google.ads.googleads.v5.services.stub.CampaignDraftServiceStub;
import com.google.ads.googleads.v5.services.stub.GrpcCampaignDraftServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.rpc.Status;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class CampaignDraftServiceStubSettings
extends StubSettings<CampaignDraftServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().build();
    private final UnaryCallSettings<GetCampaignDraftRequest, CampaignDraft> getCampaignDraftSettings;
    private final UnaryCallSettings<MutateCampaignDraftsRequest, MutateCampaignDraftsResponse> mutateCampaignDraftsSettings;
    private final UnaryCallSettings<PromoteCampaignDraftRequest, Operation> promoteCampaignDraftSettings;
    private final OperationCallSettings<PromoteCampaignDraftRequest, Empty, Empty> promoteCampaignDraftOperationSettings;
    private final PagedCallSettings<ListCampaignDraftAsyncErrorsRequest, ListCampaignDraftAsyncErrorsResponse, CampaignDraftServiceClient.ListCampaignDraftAsyncErrorsPagedResponse> listCampaignDraftAsyncErrorsSettings;
    private static final PagedListDescriptor<ListCampaignDraftAsyncErrorsRequest, ListCampaignDraftAsyncErrorsResponse, Status> LIST_CAMPAIGN_DRAFT_ASYNC_ERRORS_PAGE_STR_DESC = new PagedListDescriptor<ListCampaignDraftAsyncErrorsRequest, ListCampaignDraftAsyncErrorsResponse, Status>(){

        public String emptyToken() {
            return "";
        }

        public ListCampaignDraftAsyncErrorsRequest injectToken(ListCampaignDraftAsyncErrorsRequest payload, String token) {
            return ListCampaignDraftAsyncErrorsRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListCampaignDraftAsyncErrorsRequest injectPageSize(ListCampaignDraftAsyncErrorsRequest payload, int pageSize) {
            return ListCampaignDraftAsyncErrorsRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCampaignDraftAsyncErrorsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCampaignDraftAsyncErrorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Status> extractResources(ListCampaignDraftAsyncErrorsResponse payload) {
            return payload.getErrorsList() != null ? payload.getErrorsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListCampaignDraftAsyncErrorsRequest, ListCampaignDraftAsyncErrorsResponse, CampaignDraftServiceClient.ListCampaignDraftAsyncErrorsPagedResponse> LIST_CAMPAIGN_DRAFT_ASYNC_ERRORS_PAGE_STR_FACT = new PagedListResponseFactory<ListCampaignDraftAsyncErrorsRequest, ListCampaignDraftAsyncErrorsResponse, CampaignDraftServiceClient.ListCampaignDraftAsyncErrorsPagedResponse>(){

        public ApiFuture<CampaignDraftServiceClient.ListCampaignDraftAsyncErrorsPagedResponse> getFuturePagedResponse(UnaryCallable<ListCampaignDraftAsyncErrorsRequest, ListCampaignDraftAsyncErrorsResponse> callable, ListCampaignDraftAsyncErrorsRequest request, ApiCallContext context, ApiFuture<ListCampaignDraftAsyncErrorsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CAMPAIGN_DRAFT_ASYNC_ERRORS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CampaignDraftServiceClient.ListCampaignDraftAsyncErrorsPagedResponse.createAsync((PageContext<ListCampaignDraftAsyncErrorsRequest, ListCampaignDraftAsyncErrorsResponse, Status>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetCampaignDraftRequest, CampaignDraft> getCampaignDraftSettings() {
        return this.getCampaignDraftSettings;
    }

    public UnaryCallSettings<MutateCampaignDraftsRequest, MutateCampaignDraftsResponse> mutateCampaignDraftsSettings() {
        return this.mutateCampaignDraftsSettings;
    }

    public UnaryCallSettings<PromoteCampaignDraftRequest, Operation> promoteCampaignDraftSettings() {
        return this.promoteCampaignDraftSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<PromoteCampaignDraftRequest, Empty, Empty> promoteCampaignDraftOperationSettings() {
        return this.promoteCampaignDraftOperationSettings;
    }

    public PagedCallSettings<ListCampaignDraftAsyncErrorsRequest, ListCampaignDraftAsyncErrorsResponse, CampaignDraftServiceClient.ListCampaignDraftAsyncErrorsPagedResponse> listCampaignDraftAsyncErrorsSettings() {
        return this.listCampaignDraftAsyncErrorsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CampaignDraftServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCampaignDraftServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "googleads.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CampaignDraftServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CampaignDraftServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CampaignDraftServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getCampaignDraftSettings = settingsBuilder.getCampaignDraftSettings().build();
        this.mutateCampaignDraftsSettings = settingsBuilder.mutateCampaignDraftsSettings().build();
        this.promoteCampaignDraftSettings = settingsBuilder.promoteCampaignDraftSettings().build();
        this.promoteCampaignDraftOperationSettings = settingsBuilder.promoteCampaignDraftOperationSettings().build();
        this.listCampaignDraftAsyncErrorsSettings = settingsBuilder.listCampaignDraftAsyncErrorsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CampaignDraftServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetCampaignDraftRequest, CampaignDraft> getCampaignDraftSettings;
        private final UnaryCallSettings.Builder<MutateCampaignDraftsRequest, MutateCampaignDraftsResponse> mutateCampaignDraftsSettings;
        private final UnaryCallSettings.Builder<PromoteCampaignDraftRequest, Operation> promoteCampaignDraftSettings;
        private final OperationCallSettings.Builder<PromoteCampaignDraftRequest, Empty, Empty> promoteCampaignDraftOperationSettings;
        private final PagedCallSettings.Builder<ListCampaignDraftAsyncErrorsRequest, ListCampaignDraftAsyncErrorsResponse, CampaignDraftServiceClient.ListCampaignDraftAsyncErrorsPagedResponse> listCampaignDraftAsyncErrorsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getCampaignDraftSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.mutateCampaignDraftsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.promoteCampaignDraftSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.promoteCampaignDraftOperationSettings = OperationCallSettings.newBuilder();
            this.listCampaignDraftAsyncErrorsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CAMPAIGN_DRAFT_ASYNC_ERRORS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getCampaignDraftSettings, this.mutateCampaignDraftsSettings, this.promoteCampaignDraftSettings, this.listCampaignDraftAsyncErrorsSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CampaignDraftServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CampaignDraftServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CampaignDraftServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(CampaignDraftServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getCampaignDraftSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.mutateCampaignDraftsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.promoteCampaignDraftSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listCampaignDraftAsyncErrorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.promoteCampaignDraftOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Empty.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        protected Builder(CampaignDraftServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getCampaignDraftSettings = settings.getCampaignDraftSettings.toBuilder();
            this.mutateCampaignDraftsSettings = settings.mutateCampaignDraftsSettings.toBuilder();
            this.promoteCampaignDraftSettings = settings.promoteCampaignDraftSettings.toBuilder();
            this.promoteCampaignDraftOperationSettings = settings.promoteCampaignDraftOperationSettings.toBuilder();
            this.listCampaignDraftAsyncErrorsSettings = settings.listCampaignDraftAsyncErrorsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getCampaignDraftSettings, this.mutateCampaignDraftsSettings, this.promoteCampaignDraftSettings, this.listCampaignDraftAsyncErrorsSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetCampaignDraftRequest, CampaignDraft> getCampaignDraftSettings() {
            return this.getCampaignDraftSettings;
        }

        public UnaryCallSettings.Builder<MutateCampaignDraftsRequest, MutateCampaignDraftsResponse> mutateCampaignDraftsSettings() {
            return this.mutateCampaignDraftsSettings;
        }

        public UnaryCallSettings.Builder<PromoteCampaignDraftRequest, Operation> promoteCampaignDraftSettings() {
            return this.promoteCampaignDraftSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<PromoteCampaignDraftRequest, Empty, Empty> promoteCampaignDraftOperationSettings() {
            return this.promoteCampaignDraftOperationSettings;
        }

        public PagedCallSettings.Builder<ListCampaignDraftAsyncErrorsRequest, ListCampaignDraftAsyncErrorsResponse, CampaignDraftServiceClient.ListCampaignDraftAsyncErrorsPagedResponse> listCampaignDraftAsyncErrorsSettings() {
            return this.listCampaignDraftAsyncErrorsSettings;
        }

        public CampaignDraftServiceStubSettings build() throws IOException {
            return new CampaignDraftServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)3600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)3600000L)).setTotalTimeout(Duration.ofMillis((long)3600000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)3600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)3600000L)).setTotalTimeout(Duration.ofMillis((long)3600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

