/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services.stub;

import com.google.ads.googleads.v5.resources.AccountBudget;
import com.google.ads.googleads.v5.services.GetAccountBudgetRequest;
import com.google.ads.googleads.v5.services.stub.AccountBudgetServiceStub;
import com.google.ads.googleads.v5.services.stub.AccountBudgetServiceStubSettings;
import com.google.ads.googleads.v5.services.stub.GrpcAccountBudgetServiceCallableFactory;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class GrpcAccountBudgetServiceStub
extends AccountBudgetServiceStub {
    private static final MethodDescriptor<GetAccountBudgetRequest, AccountBudget> getAccountBudgetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v5.services.AccountBudgetService/GetAccountBudget").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAccountBudgetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AccountBudget.getDefaultInstance())).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<GetAccountBudgetRequest, AccountBudget> getAccountBudgetCallable;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAccountBudgetServiceStub create(AccountBudgetServiceStubSettings settings) throws IOException {
        return new GrpcAccountBudgetServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAccountBudgetServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAccountBudgetServiceStub(AccountBudgetServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAccountBudgetServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAccountBudgetServiceStub(AccountBudgetServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAccountBudgetServiceStub(AccountBudgetServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAccountBudgetServiceCallableFactory());
    }

    protected GrpcAccountBudgetServiceStub(AccountBudgetServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        GrpcCallSettings getAccountBudgetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAccountBudgetMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetAccountBudgetRequest>(){

            public Map<String, String> extract(GetAccountBudgetRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        this.getAccountBudgetCallable = callableFactory.createUnaryCallable(getAccountBudgetTransportSettings, settings.getAccountBudgetSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<GetAccountBudgetRequest, AccountBudget> getAccountBudgetCallable() {
        return this.getAccountBudgetCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

