/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services.stub;

import com.google.ads.googleads.v5.resources.AdGroupExtensionSetting;
import com.google.ads.googleads.v5.services.GetAdGroupExtensionSettingRequest;
import com.google.ads.googleads.v5.services.MutateAdGroupExtensionSettingsRequest;
import com.google.ads.googleads.v5.services.MutateAdGroupExtensionSettingsResponse;
import com.google.ads.googleads.v5.services.stub.AdGroupExtensionSettingServiceStub;
import com.google.ads.googleads.v5.services.stub.AdGroupExtensionSettingServiceStubSettings;
import com.google.ads.googleads.v5.services.stub.GrpcAdGroupExtensionSettingServiceCallableFactory;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class GrpcAdGroupExtensionSettingServiceStub
extends AdGroupExtensionSettingServiceStub {
    private static final MethodDescriptor<GetAdGroupExtensionSettingRequest, AdGroupExtensionSetting> getAdGroupExtensionSettingMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v5.services.AdGroupExtensionSettingService/GetAdGroupExtensionSetting").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAdGroupExtensionSettingRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AdGroupExtensionSetting.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateAdGroupExtensionSettingsRequest, MutateAdGroupExtensionSettingsResponse> mutateAdGroupExtensionSettingsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v5.services.AdGroupExtensionSettingService/MutateAdGroupExtensionSettings").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateAdGroupExtensionSettingsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateAdGroupExtensionSettingsResponse.getDefaultInstance())).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<GetAdGroupExtensionSettingRequest, AdGroupExtensionSetting> getAdGroupExtensionSettingCallable;
    private final UnaryCallable<MutateAdGroupExtensionSettingsRequest, MutateAdGroupExtensionSettingsResponse> mutateAdGroupExtensionSettingsCallable;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAdGroupExtensionSettingServiceStub create(AdGroupExtensionSettingServiceStubSettings settings) throws IOException {
        return new GrpcAdGroupExtensionSettingServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAdGroupExtensionSettingServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAdGroupExtensionSettingServiceStub(AdGroupExtensionSettingServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAdGroupExtensionSettingServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAdGroupExtensionSettingServiceStub(AdGroupExtensionSettingServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAdGroupExtensionSettingServiceStub(AdGroupExtensionSettingServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAdGroupExtensionSettingServiceCallableFactory());
    }

    protected GrpcAdGroupExtensionSettingServiceStub(AdGroupExtensionSettingServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        GrpcCallSettings getAdGroupExtensionSettingTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAdGroupExtensionSettingMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetAdGroupExtensionSettingRequest>(){

            public Map<String, String> extract(GetAdGroupExtensionSettingRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateAdGroupExtensionSettingsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateAdGroupExtensionSettingsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateAdGroupExtensionSettingsRequest>(){

            public Map<String, String> extract(MutateAdGroupExtensionSettingsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.getAdGroupExtensionSettingCallable = callableFactory.createUnaryCallable(getAdGroupExtensionSettingTransportSettings, settings.getAdGroupExtensionSettingSettings(), clientContext);
        this.mutateAdGroupExtensionSettingsCallable = callableFactory.createUnaryCallable(mutateAdGroupExtensionSettingsTransportSettings, settings.mutateAdGroupExtensionSettingsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<GetAdGroupExtensionSettingRequest, AdGroupExtensionSetting> getAdGroupExtensionSettingCallable() {
        return this.getAdGroupExtensionSettingCallable;
    }

    @Override
    public UnaryCallable<MutateAdGroupExtensionSettingsRequest, MutateAdGroupExtensionSettingsResponse> mutateAdGroupExtensionSettingsCallable() {
        return this.mutateAdGroupExtensionSettingsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

