/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services.stub;

import com.google.ads.googleads.v5.resources.AdGroupFeed;
import com.google.ads.googleads.v5.services.GetAdGroupFeedRequest;
import com.google.ads.googleads.v5.services.MutateAdGroupFeedsRequest;
import com.google.ads.googleads.v5.services.MutateAdGroupFeedsResponse;
import com.google.ads.googleads.v5.services.stub.AdGroupFeedServiceStub;
import com.google.ads.googleads.v5.services.stub.AdGroupFeedServiceStubSettings;
import com.google.ads.googleads.v5.services.stub.GrpcAdGroupFeedServiceCallableFactory;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class GrpcAdGroupFeedServiceStub
extends AdGroupFeedServiceStub {
    private static final MethodDescriptor<GetAdGroupFeedRequest, AdGroupFeed> getAdGroupFeedMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v5.services.AdGroupFeedService/GetAdGroupFeed").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAdGroupFeedRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AdGroupFeed.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateAdGroupFeedsRequest, MutateAdGroupFeedsResponse> mutateAdGroupFeedsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v5.services.AdGroupFeedService/MutateAdGroupFeeds").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateAdGroupFeedsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateAdGroupFeedsResponse.getDefaultInstance())).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<GetAdGroupFeedRequest, AdGroupFeed> getAdGroupFeedCallable;
    private final UnaryCallable<MutateAdGroupFeedsRequest, MutateAdGroupFeedsResponse> mutateAdGroupFeedsCallable;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAdGroupFeedServiceStub create(AdGroupFeedServiceStubSettings settings) throws IOException {
        return new GrpcAdGroupFeedServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAdGroupFeedServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAdGroupFeedServiceStub(AdGroupFeedServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAdGroupFeedServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAdGroupFeedServiceStub(AdGroupFeedServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAdGroupFeedServiceStub(AdGroupFeedServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAdGroupFeedServiceCallableFactory());
    }

    protected GrpcAdGroupFeedServiceStub(AdGroupFeedServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        GrpcCallSettings getAdGroupFeedTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAdGroupFeedMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetAdGroupFeedRequest>(){

            public Map<String, String> extract(GetAdGroupFeedRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateAdGroupFeedsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateAdGroupFeedsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateAdGroupFeedsRequest>(){

            public Map<String, String> extract(MutateAdGroupFeedsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.getAdGroupFeedCallable = callableFactory.createUnaryCallable(getAdGroupFeedTransportSettings, settings.getAdGroupFeedSettings(), clientContext);
        this.mutateAdGroupFeedsCallable = callableFactory.createUnaryCallable(mutateAdGroupFeedsTransportSettings, settings.mutateAdGroupFeedsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<GetAdGroupFeedRequest, AdGroupFeed> getAdGroupFeedCallable() {
        return this.getAdGroupFeedCallable;
    }

    @Override
    public UnaryCallable<MutateAdGroupFeedsRequest, MutateAdGroupFeedsResponse> mutateAdGroupFeedsCallable() {
        return this.mutateAdGroupFeedsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

