/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services.stub;

import com.google.ads.googleads.v5.resources.AdGroupLabel;
import com.google.ads.googleads.v5.services.GetAdGroupLabelRequest;
import com.google.ads.googleads.v5.services.MutateAdGroupLabelsRequest;
import com.google.ads.googleads.v5.services.MutateAdGroupLabelsResponse;
import com.google.ads.googleads.v5.services.stub.AdGroupLabelServiceStub;
import com.google.ads.googleads.v5.services.stub.AdGroupLabelServiceStubSettings;
import com.google.ads.googleads.v5.services.stub.GrpcAdGroupLabelServiceCallableFactory;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class GrpcAdGroupLabelServiceStub
extends AdGroupLabelServiceStub {
    private static final MethodDescriptor<GetAdGroupLabelRequest, AdGroupLabel> getAdGroupLabelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v5.services.AdGroupLabelService/GetAdGroupLabel").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAdGroupLabelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AdGroupLabel.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateAdGroupLabelsRequest, MutateAdGroupLabelsResponse> mutateAdGroupLabelsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v5.services.AdGroupLabelService/MutateAdGroupLabels").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateAdGroupLabelsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateAdGroupLabelsResponse.getDefaultInstance())).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<GetAdGroupLabelRequest, AdGroupLabel> getAdGroupLabelCallable;
    private final UnaryCallable<MutateAdGroupLabelsRequest, MutateAdGroupLabelsResponse> mutateAdGroupLabelsCallable;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAdGroupLabelServiceStub create(AdGroupLabelServiceStubSettings settings) throws IOException {
        return new GrpcAdGroupLabelServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAdGroupLabelServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAdGroupLabelServiceStub(AdGroupLabelServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAdGroupLabelServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAdGroupLabelServiceStub(AdGroupLabelServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAdGroupLabelServiceStub(AdGroupLabelServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAdGroupLabelServiceCallableFactory());
    }

    protected GrpcAdGroupLabelServiceStub(AdGroupLabelServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        GrpcCallSettings getAdGroupLabelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAdGroupLabelMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetAdGroupLabelRequest>(){

            public Map<String, String> extract(GetAdGroupLabelRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateAdGroupLabelsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateAdGroupLabelsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateAdGroupLabelsRequest>(){

            public Map<String, String> extract(MutateAdGroupLabelsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.getAdGroupLabelCallable = callableFactory.createUnaryCallable(getAdGroupLabelTransportSettings, settings.getAdGroupLabelSettings(), clientContext);
        this.mutateAdGroupLabelsCallable = callableFactory.createUnaryCallable(mutateAdGroupLabelsTransportSettings, settings.mutateAdGroupLabelsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<GetAdGroupLabelRequest, AdGroupLabel> getAdGroupLabelCallable() {
        return this.getAdGroupLabelCallable;
    }

    @Override
    public UnaryCallable<MutateAdGroupLabelsRequest, MutateAdGroupLabelsResponse> mutateAdGroupLabelsCallable() {
        return this.mutateAdGroupLabelsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

