/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services.stub;

import com.google.ads.googleads.v5.resources.CustomerFeed;
import com.google.ads.googleads.v5.services.GetCustomerFeedRequest;
import com.google.ads.googleads.v5.services.MutateCustomerFeedsRequest;
import com.google.ads.googleads.v5.services.MutateCustomerFeedsResponse;
import com.google.ads.googleads.v5.services.stub.CustomerFeedServiceStub;
import com.google.ads.googleads.v5.services.stub.CustomerFeedServiceStubSettings;
import com.google.ads.googleads.v5.services.stub.GrpcCustomerFeedServiceCallableFactory;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class GrpcCustomerFeedServiceStub
extends CustomerFeedServiceStub {
    private static final MethodDescriptor<GetCustomerFeedRequest, CustomerFeed> getCustomerFeedMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v5.services.CustomerFeedService/GetCustomerFeed").setRequestMarshaller(ProtoUtils.marshaller((Message)GetCustomerFeedRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CustomerFeed.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateCustomerFeedsRequest, MutateCustomerFeedsResponse> mutateCustomerFeedsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v5.services.CustomerFeedService/MutateCustomerFeeds").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateCustomerFeedsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateCustomerFeedsResponse.getDefaultInstance())).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<GetCustomerFeedRequest, CustomerFeed> getCustomerFeedCallable;
    private final UnaryCallable<MutateCustomerFeedsRequest, MutateCustomerFeedsResponse> mutateCustomerFeedsCallable;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCustomerFeedServiceStub create(CustomerFeedServiceStubSettings settings) throws IOException {
        return new GrpcCustomerFeedServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCustomerFeedServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcCustomerFeedServiceStub(CustomerFeedServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCustomerFeedServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCustomerFeedServiceStub(CustomerFeedServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCustomerFeedServiceStub(CustomerFeedServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCustomerFeedServiceCallableFactory());
    }

    protected GrpcCustomerFeedServiceStub(CustomerFeedServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        GrpcCallSettings getCustomerFeedTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getCustomerFeedMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetCustomerFeedRequest>(){

            public Map<String, String> extract(GetCustomerFeedRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateCustomerFeedsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateCustomerFeedsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateCustomerFeedsRequest>(){

            public Map<String, String> extract(MutateCustomerFeedsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.getCustomerFeedCallable = callableFactory.createUnaryCallable(getCustomerFeedTransportSettings, settings.getCustomerFeedSettings(), clientContext);
        this.mutateCustomerFeedsCallable = callableFactory.createUnaryCallable(mutateCustomerFeedsTransportSettings, settings.mutateCustomerFeedsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<GetCustomerFeedRequest, CustomerFeed> getCustomerFeedCallable() {
        return this.getCustomerFeedCallable;
    }

    @Override
    public UnaryCallable<MutateCustomerFeedsRequest, MutateCustomerFeedsResponse> mutateCustomerFeedsCallable() {
        return this.mutateCustomerFeedsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

