/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services.stub;

import com.google.ads.googleads.v5.resources.Feed;
import com.google.ads.googleads.v5.services.GetFeedRequest;
import com.google.ads.googleads.v5.services.MutateFeedsRequest;
import com.google.ads.googleads.v5.services.MutateFeedsResponse;
import com.google.ads.googleads.v5.services.stub.FeedServiceStub;
import com.google.ads.googleads.v5.services.stub.FeedServiceStubSettings;
import com.google.ads.googleads.v5.services.stub.GrpcFeedServiceCallableFactory;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class GrpcFeedServiceStub
extends FeedServiceStub {
    private static final MethodDescriptor<GetFeedRequest, Feed> getFeedMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v5.services.FeedService/GetFeed").setRequestMarshaller(ProtoUtils.marshaller((Message)GetFeedRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Feed.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateFeedsRequest, MutateFeedsResponse> mutateFeedsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v5.services.FeedService/MutateFeeds").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateFeedsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateFeedsResponse.getDefaultInstance())).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<GetFeedRequest, Feed> getFeedCallable;
    private final UnaryCallable<MutateFeedsRequest, MutateFeedsResponse> mutateFeedsCallable;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcFeedServiceStub create(FeedServiceStubSettings settings) throws IOException {
        return new GrpcFeedServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcFeedServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcFeedServiceStub(FeedServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcFeedServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcFeedServiceStub(FeedServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcFeedServiceStub(FeedServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcFeedServiceCallableFactory());
    }

    protected GrpcFeedServiceStub(FeedServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        GrpcCallSettings getFeedTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getFeedMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetFeedRequest>(){

            public Map<String, String> extract(GetFeedRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateFeedsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateFeedsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateFeedsRequest>(){

            public Map<String, String> extract(MutateFeedsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.getFeedCallable = callableFactory.createUnaryCallable(getFeedTransportSettings, settings.getFeedSettings(), clientContext);
        this.mutateFeedsCallable = callableFactory.createUnaryCallable(mutateFeedsTransportSettings, settings.mutateFeedsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<GetFeedRequest, Feed> getFeedCallable() {
        return this.getFeedCallable;
    }

    @Override
    public UnaryCallable<MutateFeedsRequest, MutateFeedsResponse> mutateFeedsCallable() {
        return this.mutateFeedsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

