/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services.stub;

import com.google.ads.googleads.v5.services.ListInvoicesRequest;
import com.google.ads.googleads.v5.services.ListInvoicesResponse;
import com.google.ads.googleads.v5.services.stub.GrpcInvoiceServiceCallableFactory;
import com.google.ads.googleads.v5.services.stub.InvoiceServiceStub;
import com.google.ads.googleads.v5.services.stub.InvoiceServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class GrpcInvoiceServiceStub
extends InvoiceServiceStub {
    private static final MethodDescriptor<ListInvoicesRequest, ListInvoicesResponse> listInvoicesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v5.services.InvoiceService/ListInvoices").setRequestMarshaller(ProtoUtils.marshaller((Message)ListInvoicesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListInvoicesResponse.getDefaultInstance())).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<ListInvoicesRequest, ListInvoicesResponse> listInvoicesCallable;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcInvoiceServiceStub create(InvoiceServiceStubSettings settings) throws IOException {
        return new GrpcInvoiceServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcInvoiceServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcInvoiceServiceStub(InvoiceServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcInvoiceServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcInvoiceServiceStub(InvoiceServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcInvoiceServiceStub(InvoiceServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcInvoiceServiceCallableFactory());
    }

    protected GrpcInvoiceServiceStub(InvoiceServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        GrpcCallSettings listInvoicesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listInvoicesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListInvoicesRequest>(){

            public Map<String, String> extract(ListInvoicesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.listInvoicesCallable = callableFactory.createUnaryCallable(listInvoicesTransportSettings, settings.listInvoicesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<ListInvoicesRequest, ListInvoicesResponse> listInvoicesCallable() {
        return this.listInvoicesCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

