/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services.stub;

import com.google.ads.googleads.v5.resources.MediaFile;
import com.google.ads.googleads.v5.services.GetMediaFileRequest;
import com.google.ads.googleads.v5.services.MutateMediaFilesRequest;
import com.google.ads.googleads.v5.services.MutateMediaFilesResponse;
import com.google.ads.googleads.v5.services.stub.GrpcMediaFileServiceCallableFactory;
import com.google.ads.googleads.v5.services.stub.MediaFileServiceStub;
import com.google.ads.googleads.v5.services.stub.MediaFileServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class GrpcMediaFileServiceStub
extends MediaFileServiceStub {
    private static final MethodDescriptor<GetMediaFileRequest, MediaFile> getMediaFileMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v5.services.MediaFileService/GetMediaFile").setRequestMarshaller(ProtoUtils.marshaller((Message)GetMediaFileRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MediaFile.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateMediaFilesRequest, MutateMediaFilesResponse> mutateMediaFilesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v5.services.MediaFileService/MutateMediaFiles").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateMediaFilesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateMediaFilesResponse.getDefaultInstance())).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<GetMediaFileRequest, MediaFile> getMediaFileCallable;
    private final UnaryCallable<MutateMediaFilesRequest, MutateMediaFilesResponse> mutateMediaFilesCallable;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcMediaFileServiceStub create(MediaFileServiceStubSettings settings) throws IOException {
        return new GrpcMediaFileServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcMediaFileServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcMediaFileServiceStub(MediaFileServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcMediaFileServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcMediaFileServiceStub(MediaFileServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcMediaFileServiceStub(MediaFileServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcMediaFileServiceCallableFactory());
    }

    protected GrpcMediaFileServiceStub(MediaFileServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        GrpcCallSettings getMediaFileTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getMediaFileMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetMediaFileRequest>(){

            public Map<String, String> extract(GetMediaFileRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateMediaFilesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateMediaFilesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateMediaFilesRequest>(){

            public Map<String, String> extract(MutateMediaFilesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.getMediaFileCallable = callableFactory.createUnaryCallable(getMediaFileTransportSettings, settings.getMediaFileSettings(), clientContext);
        this.mutateMediaFilesCallable = callableFactory.createUnaryCallable(mutateMediaFilesTransportSettings, settings.mutateMediaFilesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<GetMediaFileRequest, MediaFile> getMediaFileCallable() {
        return this.getMediaFileCallable;
    }

    @Override
    public UnaryCallable<MutateMediaFilesRequest, MutateMediaFilesResponse> mutateMediaFilesCallable() {
        return this.mutateMediaFilesCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

