/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services.stub;

import com.google.ads.googleads.v5.resources.SharedSet;
import com.google.ads.googleads.v5.services.GetSharedSetRequest;
import com.google.ads.googleads.v5.services.MutateSharedSetsRequest;
import com.google.ads.googleads.v5.services.MutateSharedSetsResponse;
import com.google.ads.googleads.v5.services.stub.GrpcSharedSetServiceCallableFactory;
import com.google.ads.googleads.v5.services.stub.SharedSetServiceStub;
import com.google.ads.googleads.v5.services.stub.SharedSetServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class GrpcSharedSetServiceStub
extends SharedSetServiceStub {
    private static final MethodDescriptor<GetSharedSetRequest, SharedSet> getSharedSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v5.services.SharedSetService/GetSharedSet").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSharedSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SharedSet.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateSharedSetsRequest, MutateSharedSetsResponse> mutateSharedSetsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v5.services.SharedSetService/MutateSharedSets").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateSharedSetsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateSharedSetsResponse.getDefaultInstance())).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<GetSharedSetRequest, SharedSet> getSharedSetCallable;
    private final UnaryCallable<MutateSharedSetsRequest, MutateSharedSetsResponse> mutateSharedSetsCallable;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSharedSetServiceStub create(SharedSetServiceStubSettings settings) throws IOException {
        return new GrpcSharedSetServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSharedSetServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcSharedSetServiceStub(SharedSetServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSharedSetServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSharedSetServiceStub(SharedSetServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSharedSetServiceStub(SharedSetServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSharedSetServiceCallableFactory());
    }

    protected GrpcSharedSetServiceStub(SharedSetServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        GrpcCallSettings getSharedSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSharedSetMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetSharedSetRequest>(){

            public Map<String, String> extract(GetSharedSetRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateSharedSetsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateSharedSetsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateSharedSetsRequest>(){

            public Map<String, String> extract(MutateSharedSetsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.getSharedSetCallable = callableFactory.createUnaryCallable(getSharedSetTransportSettings, settings.getSharedSetSettings(), clientContext);
        this.mutateSharedSetsCallable = callableFactory.createUnaryCallable(mutateSharedSetsTransportSettings, settings.mutateSharedSetsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<GetSharedSetRequest, SharedSet> getSharedSetCallable() {
        return this.getSharedSetCallable;
    }

    @Override
    public UnaryCallable<MutateSharedSetsRequest, MutateSharedSetsResponse> mutateSharedSetsCallable() {
        return this.mutateSharedSetsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

