/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services.stub;

import com.google.ads.googleads.v5.resources.UserList;
import com.google.ads.googleads.v5.services.GetUserListRequest;
import com.google.ads.googleads.v5.services.MutateUserListsRequest;
import com.google.ads.googleads.v5.services.MutateUserListsResponse;
import com.google.ads.googleads.v5.services.stub.GrpcUserListServiceCallableFactory;
import com.google.ads.googleads.v5.services.stub.UserListServiceStub;
import com.google.ads.googleads.v5.services.stub.UserListServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class GrpcUserListServiceStub
extends UserListServiceStub {
    private static final MethodDescriptor<GetUserListRequest, UserList> getUserListMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v5.services.UserListService/GetUserList").setRequestMarshaller(ProtoUtils.marshaller((Message)GetUserListRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)UserList.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateUserListsRequest, MutateUserListsResponse> mutateUserListsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v5.services.UserListService/MutateUserLists").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateUserListsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateUserListsResponse.getDefaultInstance())).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<GetUserListRequest, UserList> getUserListCallable;
    private final UnaryCallable<MutateUserListsRequest, MutateUserListsResponse> mutateUserListsCallable;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcUserListServiceStub create(UserListServiceStubSettings settings) throws IOException {
        return new GrpcUserListServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcUserListServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcUserListServiceStub(UserListServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcUserListServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcUserListServiceStub(UserListServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcUserListServiceStub(UserListServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcUserListServiceCallableFactory());
    }

    protected GrpcUserListServiceStub(UserListServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        GrpcCallSettings getUserListTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getUserListMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetUserListRequest>(){

            public Map<String, String> extract(GetUserListRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateUserListsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateUserListsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateUserListsRequest>(){

            public Map<String, String> extract(MutateUserListsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.getUserListCallable = callableFactory.createUnaryCallable(getUserListTransportSettings, settings.getUserListSettings(), clientContext);
        this.mutateUserListsCallable = callableFactory.createUnaryCallable(mutateUserListsTransportSettings, settings.mutateUserListsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<GetUserListRequest, UserList> getUserListCallable() {
        return this.getUserListCallable;
    }

    @Override
    public UnaryCallable<MutateUserListsRequest, MutateUserListsResponse> mutateUserListsCallable() {
        return this.mutateUserListsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

