/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.utils;

import com.google.ads.googleads.v5.enums.AssetFieldTypeEnum;
import com.google.ads.googleads.v5.enums.DistanceBucketEnum;
import com.google.ads.googleads.v5.enums.ExtensionTypeEnum;
import com.google.ads.googleads.v5.enums.FeedItemTargetTypeEnum;
import com.google.ads.googleads.v5.enums.GeoTargetingTypeEnum;
import com.google.ads.googleads.v5.enums.PlaceholderTypeEnum;
import com.google.ads.googleads.v5.enums.ProductBiddingCategoryLevelEnum;
import com.google.ads.googleads.v5.enums.SimulationModificationMethodEnum;
import com.google.ads.googleads.v5.enums.SimulationTypeEnum;
import com.google.ads.googleads.v5.services.AccountBudgetName;
import com.google.ads.googleads.v5.services.AccountBudgetProposalName;
import com.google.ads.googleads.v5.services.AccountLinkName;
import com.google.ads.googleads.v5.services.AdGroupAdAssetViewName;
import com.google.ads.googleads.v5.services.AdGroupAdLabelName;
import com.google.ads.googleads.v5.services.AdGroupAdName;
import com.google.ads.googleads.v5.services.AdGroupAudienceViewName;
import com.google.ads.googleads.v5.services.AdGroupBidModifierName;
import com.google.ads.googleads.v5.services.AdGroupCriterionLabelName;
import com.google.ads.googleads.v5.services.AdGroupCriterionName;
import com.google.ads.googleads.v5.services.AdGroupCriterionSimulationName;
import com.google.ads.googleads.v5.services.AdGroupExtensionSettingName;
import com.google.ads.googleads.v5.services.AdGroupFeedName;
import com.google.ads.googleads.v5.services.AdGroupLabelName;
import com.google.ads.googleads.v5.services.AdGroupName;
import com.google.ads.googleads.v5.services.AdGroupSimulationName;
import com.google.ads.googleads.v5.services.AdName;
import com.google.ads.googleads.v5.services.AdParameterName;
import com.google.ads.googleads.v5.services.AdScheduleViewName;
import com.google.ads.googleads.v5.services.AgeRangeViewName;
import com.google.ads.googleads.v5.services.AssetName;
import com.google.ads.googleads.v5.services.BatchJobName;
import com.google.ads.googleads.v5.services.BiddingStrategyName;
import com.google.ads.googleads.v5.services.BillingSetupName;
import com.google.ads.googleads.v5.services.CampaignAssetName;
import com.google.ads.googleads.v5.services.CampaignAudienceViewName;
import com.google.ads.googleads.v5.services.CampaignBidModifierName;
import com.google.ads.googleads.v5.services.CampaignBudgetName;
import com.google.ads.googleads.v5.services.CampaignCriterionName;
import com.google.ads.googleads.v5.services.CampaignCriterionSimulationName;
import com.google.ads.googleads.v5.services.CampaignDraftName;
import com.google.ads.googleads.v5.services.CampaignExperimentName;
import com.google.ads.googleads.v5.services.CampaignExtensionSettingName;
import com.google.ads.googleads.v5.services.CampaignFeedName;
import com.google.ads.googleads.v5.services.CampaignLabelName;
import com.google.ads.googleads.v5.services.CampaignName;
import com.google.ads.googleads.v5.services.CampaignSharedSetName;
import com.google.ads.googleads.v5.services.CarrierConstantName;
import com.google.ads.googleads.v5.services.ChangeStatusName;
import com.google.ads.googleads.v5.services.ClickViewName;
import com.google.ads.googleads.v5.services.ConversionActionName;
import com.google.ads.googleads.v5.services.CurrencyConstantName;
import com.google.ads.googleads.v5.services.CustomInterestName;
import com.google.ads.googleads.v5.services.CustomerClientLinkName;
import com.google.ads.googleads.v5.services.CustomerClientName;
import com.google.ads.googleads.v5.services.CustomerExtensionSettingName;
import com.google.ads.googleads.v5.services.CustomerFeedName;
import com.google.ads.googleads.v5.services.CustomerLabelName;
import com.google.ads.googleads.v5.services.CustomerManagerLinkName;
import com.google.ads.googleads.v5.services.CustomerName;
import com.google.ads.googleads.v5.services.CustomerNegativeCriterionName;
import com.google.ads.googleads.v5.services.DetailPlacementViewName;
import com.google.ads.googleads.v5.services.DisplayKeywordViewName;
import com.google.ads.googleads.v5.services.DistanceViewName;
import com.google.ads.googleads.v5.services.DomainCategoryName;
import com.google.ads.googleads.v5.services.DynamicSearchAdsSearchTermViewName;
import com.google.ads.googleads.v5.services.ExpandedLandingPageViewName;
import com.google.ads.googleads.v5.services.ExtensionFeedItemName;
import com.google.ads.googleads.v5.services.FeedItemName;
import com.google.ads.googleads.v5.services.FeedItemTargetName;
import com.google.ads.googleads.v5.services.FeedMappingName;
import com.google.ads.googleads.v5.services.FeedName;
import com.google.ads.googleads.v5.services.FeedPlaceholderViewName;
import com.google.ads.googleads.v5.services.GenderViewName;
import com.google.ads.googleads.v5.services.GeoTargetConstantName;
import com.google.ads.googleads.v5.services.GeographicViewName;
import com.google.ads.googleads.v5.services.GoogleAdsFieldName;
import com.google.ads.googleads.v5.services.GroupPlacementViewName;
import com.google.ads.googleads.v5.services.HotelGroupViewName;
import com.google.ads.googleads.v5.services.HotelPerformanceViewName;
import com.google.ads.googleads.v5.services.IncomeRangeViewName;
import com.google.ads.googleads.v5.services.InvoiceName;
import com.google.ads.googleads.v5.services.KeywordPlanAdGroupKeywordName;
import com.google.ads.googleads.v5.services.KeywordPlanAdGroupName;
import com.google.ads.googleads.v5.services.KeywordPlanCampaignKeywordName;
import com.google.ads.googleads.v5.services.KeywordPlanCampaignName;
import com.google.ads.googleads.v5.services.KeywordPlanName;
import com.google.ads.googleads.v5.services.KeywordViewName;
import com.google.ads.googleads.v5.services.LabelName;
import com.google.ads.googleads.v5.services.LandingPageViewName;
import com.google.ads.googleads.v5.services.LanguageConstantName;
import com.google.ads.googleads.v5.services.LocationViewName;
import com.google.ads.googleads.v5.services.ManagedPlacementViewName;
import com.google.ads.googleads.v5.services.MediaFileName;
import com.google.ads.googleads.v5.services.MerchantCenterLinkName;
import com.google.ads.googleads.v5.services.MobileAppCategoryConstantName;
import com.google.ads.googleads.v5.services.MobileDeviceConstantName;
import com.google.ads.googleads.v5.services.OfflineUserDataJobName;
import com.google.ads.googleads.v5.services.OperatingSystemVersionConstantName;
import com.google.ads.googleads.v5.services.PaidOrganicSearchTermViewName;
import com.google.ads.googleads.v5.services.ParentalStatusViewName;
import com.google.ads.googleads.v5.services.ProductBiddingCategoryConstantName;
import com.google.ads.googleads.v5.services.ProductGroupViewName;
import com.google.ads.googleads.v5.services.RecommendationName;
import com.google.ads.googleads.v5.services.RemarketingActionName;
import com.google.ads.googleads.v5.services.SearchTermViewName;
import com.google.ads.googleads.v5.services.SharedCriterionName;
import com.google.ads.googleads.v5.services.SharedSetName;
import com.google.ads.googleads.v5.services.ShoppingPerformanceViewName;
import com.google.ads.googleads.v5.services.ThirdPartyAppAnalyticsLinkName;
import com.google.ads.googleads.v5.services.TopicConstantName;
import com.google.ads.googleads.v5.services.TopicViewName;
import com.google.ads.googleads.v5.services.UserInterestName;
import com.google.ads.googleads.v5.services.UserListName;
import com.google.ads.googleads.v5.services.UserLocationViewName;
import com.google.ads.googleads.v5.services.VideoName;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ResourceNames {
    public static String accountLink(long customerId, long accountLinkId) {
        return AccountLinkName.format(String.valueOf(customerId), String.valueOf(accountLinkId));
    }

    public static String accountBudget(long customerId, long accountBudgetId) {
        return AccountBudgetName.format(String.valueOf(customerId), String.valueOf(accountBudgetId));
    }

    public static String accountBudgetProposal(long customerId, long accountBudgetProposalId) {
        return AccountBudgetProposalName.format(String.valueOf(customerId), String.valueOf(accountBudgetProposalId));
    }

    public static String ad(long customerId, long adId) {
        return AdName.format(String.valueOf(customerId), String.valueOf(adId));
    }

    public static String adGroup(long customerId, long adGroupId) {
        return AdGroupName.format(String.valueOf(customerId), String.valueOf(adGroupId));
    }

    public static String adGroupAd(long customerId, long adGroupId, long adId) {
        return AdGroupAdName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(adGroupId, adId));
    }

    public static String adGroupAdAssetView(long customerId, long adGroupId, long adId, long assetId, AssetFieldTypeEnum.AssetFieldType fieldType) {
        return AdGroupAdAssetViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(new Object[]{adGroupId, adId, assetId, fieldType}));
    }

    public static String adGroupAdLabel(long customerId, long adGroupId, long adId, long labelId) {
        return AdGroupAdLabelName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(adGroupId, adId, labelId));
    }

    public static String adGroupAudienceView(long customerId, long adGroupId, long criterionId) {
        return AdGroupAudienceViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(adGroupId, criterionId));
    }

    public static String adGroupBidModifier(long customerId, long adGroupId, long criterionId) {
        return AdGroupBidModifierName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(adGroupId, criterionId));
    }

    public static String adGroupCriterion(long customerId, long adGroupId, long criterionId) {
        return AdGroupCriterionName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(adGroupId, criterionId));
    }

    public static String adGroupCriterionLabel(long customerId, long adGroupId, long criterionId, long labelId) {
        return AdGroupCriterionLabelName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(adGroupId, criterionId, labelId));
    }

    public static String adGroupCriterionSimulation(long customerId, long adGroupId, long criterionId, SimulationTypeEnum.SimulationType type, SimulationModificationMethodEnum.SimulationModificationMethod method, String startDate, String endDate) {
        return AdGroupCriterionSimulationName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(new Object[]{adGroupId, criterionId, type, method, startDate, endDate}));
    }

    public static String adGroupExtensionSetting(long customerId, long adGroupId, ExtensionTypeEnum.ExtensionType extensionType) {
        return AdGroupExtensionSettingName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(adGroupId, extensionType.name()));
    }

    public static String adGroupFeed(long customerId, long adGroupId, long feedId) {
        return AdGroupFeedName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(adGroupId, feedId));
    }

    public static String adGroupLabel(long customerId, long adGroupId, long labelId) {
        return AdGroupLabelName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(adGroupId, labelId));
    }

    public static String adGroupSimulation(long customerId, long adGroupId, SimulationTypeEnum.SimulationType type, SimulationModificationMethodEnum.SimulationModificationMethod method, String startDate, String endDate) {
        return AdGroupSimulationName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(new Object[]{adGroupId, type, method, startDate, endDate}));
    }

    public static String adParameter(long customerId, long adGroupId, long criterionId, long parameterIndex) {
        return AdParameterName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(adGroupId, criterionId, parameterIndex));
    }

    public static String adScheduleView(long customerId, long campaignId, long criterionId) {
        return AdScheduleViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(campaignId, criterionId));
    }

    public static String ageRangeView(long customerId, long adGroupId, long criterionId) {
        return AgeRangeViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(adGroupId, criterionId));
    }

    public static String asset(long customerId, long assetId) {
        return AssetName.format(String.valueOf(customerId), String.valueOf(assetId));
    }

    public static String biddingStrategy(long customerId, long biddingStrategyId) {
        return BiddingStrategyName.format(String.valueOf(customerId), String.valueOf(biddingStrategyId));
    }

    public static String billingSetup(long customerId, long billingSetupId) {
        return BillingSetupName.format(String.valueOf(customerId), String.valueOf(billingSetupId));
    }

    public static String campaign(long customerId, long campaignId) {
        return CampaignName.format(String.valueOf(customerId), String.valueOf(campaignId));
    }

    public static String campaignAsset(long customerId, long campaignId, long assetId, AssetFieldTypeEnum.AssetFieldType fieldType) {
        return CampaignAssetName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(new Object[]{campaignId, assetId, fieldType}));
    }

    public static String campaignAudienceView(long customerId, long campaignId, long criterionId) {
        return CampaignAudienceViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(campaignId, criterionId));
    }

    public static String campaignBidModifier(long customerId, long campaignId, long criterionId) {
        return CampaignBidModifierName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(campaignId, criterionId));
    }

    public static String campaignBudget(long customerId, long budgetId) {
        return CampaignBudgetName.format(String.valueOf(customerId), String.valueOf(budgetId));
    }

    public static String campaignCriterion(long customerId, long campaignId, long criterionId) {
        return CampaignCriterionName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(campaignId, criterionId));
    }

    public static String campaignCriterionSimulation(long customerId, long campaignId, SimulationTypeEnum.SimulationType type, SimulationModificationMethodEnum.SimulationModificationMethod method, String startDate, String endDate) {
        return CampaignCriterionSimulationName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(new Object[]{campaignId, type, method, startDate, endDate}));
    }

    public static String campaignDraft(long customerId, long baseCampaignId, long draftId) {
        return CampaignDraftName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(baseCampaignId, draftId));
    }

    public static String campaignExperiment(long customerId, long campaignExperimentId) {
        return CampaignExperimentName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(campaignExperimentId));
    }

    public static String campaignExtensionSetting(long customerId, long campaignId, ExtensionTypeEnum.ExtensionType extensionType) {
        return CampaignExtensionSettingName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(campaignId, extensionType.name()));
    }

    public static String campaignFeed(long customerId, long campaignId, long feedId) {
        return CampaignFeedName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(campaignId, feedId));
    }

    public static String campaignLabel(long customerId, long campaignId, long labelId) {
        return CampaignLabelName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(campaignId, labelId));
    }

    public static String campaignSharedSet(long customerId, long campaignId, long sharedSetId) {
        return CampaignSharedSetName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(campaignId, sharedSetId));
    }

    public static String carrierConstant(long criterionId) {
        return CarrierConstantName.format(String.valueOf(criterionId));
    }

    public static String changeStatus(long customerId, String changeStatusId) {
        return ChangeStatusName.format(String.valueOf(customerId), changeStatusId);
    }

    public static String clickView(long customerId, String date, String gclid) {
        return ClickViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(date, gclid));
    }

    public static String conversionAction(long customerId, long conversionActionId) {
        return ConversionActionName.format(String.valueOf(customerId), String.valueOf(conversionActionId));
    }

    public static String currencyConstant(String currencyCode) {
        return CurrencyConstantName.format(currencyCode);
    }

    public static String customInterest(long customerId, long customInterestId) {
        return CustomInterestName.format(String.valueOf(customerId), String.valueOf(customInterestId));
    }

    public static String customer(long customerId) {
        return CustomerName.format(String.valueOf(customerId));
    }

    public static String customerClient(long customerId, long clientCustomerId) {
        return CustomerClientName.format(String.valueOf(customerId), String.valueOf(clientCustomerId));
    }

    public static String customerClientLink(long customerId, long clientCustomerId, long managerLinkId) {
        return CustomerClientLinkName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(clientCustomerId, managerLinkId));
    }

    public static String customerExtensionSetting(long customerId, ExtensionTypeEnum.ExtensionType extensionType) {
        return CustomerExtensionSettingName.format(String.valueOf(customerId), extensionType.name());
    }

    public static String customerFeed(long customerId, long feedId) {
        return CustomerFeedName.format(String.valueOf(customerId), String.valueOf(feedId));
    }

    public static String customerLabel(long customerId, long labelId) {
        return CustomerLabelName.format(String.valueOf(customerId), String.valueOf(labelId));
    }

    public static String customerManagerLink(long customerId, long managerCustomerId, long managerLinkId) {
        return CustomerManagerLinkName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(managerCustomerId, managerLinkId));
    }

    @Deprecated
    public static String customerNegativeCriteria(long customerId, long criterionId) {
        return CustomerNegativeCriterionName.format(String.valueOf(customerId), String.valueOf(criterionId));
    }

    public static String customerNegativeCriterion(long customerId, long criterionId) {
        return CustomerNegativeCriterionName.format(String.valueOf(customerId), String.valueOf(criterionId));
    }

    public static String detailPlacementView(long customerId, long adGroupId, String placementBase64) {
        return DetailPlacementViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(adGroupId, placementBase64));
    }

    public static String displayKeywordView(long customerId, long adGroupId, long criterionId) {
        return DisplayKeywordViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(adGroupId, criterionId));
    }

    public static String distanceView(long customerId, long chainId, DistanceBucketEnum.DistanceBucket distanceBucket) {
        return DistanceViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(new Object[]{chainId, distanceBucket}));
    }

    public static String domainCategory(long customerId, long campaignId, String categoryBase64, String languageCode) {
        return DomainCategoryName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(campaignId, categoryBase64, languageCode));
    }

    public static String dynamicSearchAdsSearchTermView(long customerId, long adGroupId, String searchTerm, String headline, String landingPage) {
        return DynamicSearchAdsSearchTermViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(adGroupId, searchTerm, headline, landingPage));
    }

    public static String expandedLandingPageView(long customerId, String expandedFinalUrlFingerprint) {
        return ExpandedLandingPageViewName.format(String.valueOf(customerId), expandedFinalUrlFingerprint);
    }

    public static String extensionFeedItem(long customerId, long feedItemId) {
        return ExtensionFeedItemName.format(String.valueOf(customerId), String.valueOf(feedItemId));
    }

    public static String feed(long customerId, long feedId) {
        return FeedName.format(String.valueOf(customerId), String.valueOf(feedId));
    }

    public static String feedItem(long customerId, long feedId, long feedItemId) {
        return FeedItemName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(feedId, feedItemId));
    }

    public static String feedItemTarget(long customerId, long feedId, long feedItemId, FeedItemTargetTypeEnum.FeedItemTargetType targetType, long feedItemTargetId) {
        return FeedItemTargetName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(feedId, feedItemId, targetType.name(), feedItemTargetId));
    }

    public static String feedMapping(long customerId, long feedId, long feedMappingId) {
        return FeedMappingName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(feedId, feedMappingId));
    }

    public static String feedPlaceholderView(long customerId, PlaceholderTypeEnum.PlaceholderType placeholderType) {
        return FeedPlaceholderViewName.format(String.valueOf(customerId), placeholderType.name());
    }

    public static String genderView(long customerId, long adGroupId, long criterionId) {
        return GenderViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(adGroupId, criterionId));
    }

    public static String geoTargetConstant(long criterionId) {
        return GeoTargetConstantName.format(String.valueOf(criterionId));
    }

    public static String geographicView(long customerId, long countryCriterionId, GeoTargetingTypeEnum.GeoTargetingType targetType) {
        return GeographicViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(countryCriterionId, targetType.name()));
    }

    public static String googleAdsField(String field) {
        return GoogleAdsFieldName.format(field);
    }

    public static String groupPlacementView(long customerId, long adGroupId, String placementBase64) {
        return GroupPlacementViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(adGroupId, placementBase64));
    }

    public static String hotelGroupView(long customerId, long adGroupId, long criterionId) {
        return HotelGroupViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(adGroupId, criterionId));
    }

    public static String hotelPerformanceView(long customerId) {
        return HotelPerformanceViewName.format(String.valueOf(customerId));
    }

    public static String incomeRangeView(long customerId, long adGroupId, long criterionId) {
        return IncomeRangeViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(String.valueOf(adGroupId), String.valueOf(criterionId)));
    }

    public static String invoice(long customerId, long invoiceId) {
        return InvoiceName.format(String.valueOf(customerId), String.valueOf(invoiceId));
    }

    public static String keywordPlan(long customerId, long kpPlanId) {
        return KeywordPlanName.format(String.valueOf(customerId), String.valueOf(kpPlanId));
    }

    public static String keywordPlanAdGroup(long customerId, long kpAdGroupId) {
        return KeywordPlanAdGroupName.format(String.valueOf(customerId), String.valueOf(kpAdGroupId));
    }

    public static String keywordPlanCampaign(long customerId, long kpCampaignId) {
        return KeywordPlanCampaignName.format(String.valueOf(customerId), String.valueOf(kpCampaignId));
    }

    public static String keywordPlanAdGroupKeyword(long customerId, long kpAdGroupKeywordId) {
        return KeywordPlanAdGroupKeywordName.format(String.valueOf(customerId), String.valueOf(kpAdGroupKeywordId));
    }

    public static String keywordPlanCampaignKeyword(long customerId, long kpCampaignKeywordId) {
        return KeywordPlanCampaignKeywordName.format(String.valueOf(customerId), String.valueOf(kpCampaignKeywordId));
    }

    public static String keywordView(long customerId, long adGroupId, long criterionId) {
        return KeywordViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(adGroupId, criterionId));
    }

    public static String label(long customerId, long labelId) {
        return LabelName.format(String.valueOf(customerId), String.valueOf(labelId));
    }

    public static String landingPageView(long customerId, String unexpandedFinalUrlFingerprint) {
        return LandingPageViewName.format(String.valueOf(customerId), unexpandedFinalUrlFingerprint);
    }

    public static String languageConstant(long criterionId) {
        return LanguageConstantName.format(String.valueOf(criterionId));
    }

    public static String locationView(long customerId, long campaignId, long criterionId) {
        return LocationViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(campaignId, criterionId));
    }

    public static String managedPlacementView(long customerId, long adGroupId, long criterionId) {
        return ManagedPlacementViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(adGroupId, criterionId));
    }

    public static String mediaFile(long customerId, long mediaId) {
        return MediaFileName.format(String.valueOf(customerId), String.valueOf(mediaId));
    }

    public static String merchantCenterLink(long customerId, long merchantCenterId) {
        return MerchantCenterLinkName.format(String.valueOf(customerId), String.valueOf(merchantCenterId));
    }

    public static String mobileAppCategoryConstant(long mobileAppCategoryId) {
        return MobileAppCategoryConstantName.format(String.valueOf(mobileAppCategoryId));
    }

    public static String mobileDeviceConstant(long criterionId) {
        return MobileDeviceConstantName.format(String.valueOf(criterionId));
    }

    public static String batchJob(long customerId, long mutateJobId) {
        return BatchJobName.format(String.valueOf(customerId), String.valueOf(mutateJobId));
    }

    public static String offlineUserDataJob(long customerId, long offlineUserDataJobId) {
        return OfflineUserDataJobName.format(String.valueOf(customerId), String.valueOf(offlineUserDataJobId));
    }

    public static String operatingSystemVersionConstant(long criterionId) {
        return OperatingSystemVersionConstantName.format(String.valueOf(criterionId));
    }

    public static String paidOrganicSearchTermView(long customerId, long campaignId, long adGroupid, String searchTermBase64) {
        return PaidOrganicSearchTermViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(campaignId, adGroupid, searchTermBase64));
    }

    public static String parentalStatusView(long customerId, long adGroupId, long criterionId) {
        return ParentalStatusViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(adGroupId, criterionId));
    }

    public static String paymentsAccount(long customerId, String paymentsAccountId) {
        return String.format("customers/%s/paymentsAccounts/%s", String.valueOf(customerId), paymentsAccountId);
    }

    public static String productBiddingCategoryConstant(String countryCode, ProductBiddingCategoryLevelEnum.ProductBiddingCategoryLevel level, long constantId) {
        return ProductBiddingCategoryConstantName.format(ResourceNames.concatIdentifiers(countryCode, level.name(), constantId));
    }

    public static String productGroupView(long customerId, long adgroupId, long criterionId) {
        return ProductGroupViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(adgroupId, criterionId));
    }

    public static String recommendation(long customerId, String recommendationId) {
        return RecommendationName.format(String.valueOf(customerId), recommendationId);
    }

    public static String remarketingAction(long customerId, long remarketingActionId) {
        return RemarketingActionName.format(String.valueOf(customerId), String.valueOf(remarketingActionId));
    }

    public static String searchTermView(long customerId, long campaignId, long adGroupId, String query) {
        return SearchTermViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(campaignId, adGroupId, query));
    }

    public static String sharedCriterion(long customerId, long sharedSetId, long criterionId) {
        return SharedCriterionName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(sharedSetId, criterionId));
    }

    public static String sharedSet(long customerId, long sharedSetId) {
        return SharedSetName.format(String.valueOf(customerId), String.valueOf(sharedSetId));
    }

    public static String shoppingPerformanceView(long customerId) {
        return ShoppingPerformanceViewName.format(String.valueOf(customerId));
    }

    public static String thirdPartyAppAnalyticsLink(long customerId, long customerLinkId) {
        return ThirdPartyAppAnalyticsLinkName.format(String.valueOf(customerId), String.valueOf(customerLinkId));
    }

    public static String topicConstant(long verticalId) {
        return TopicConstantName.format(String.valueOf(verticalId));
    }

    public static String topicView(long customerId, long adGroupId, long criterionId) {
        return TopicViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(adGroupId, criterionId));
    }

    public static String userInterest(long customerId, long categoryId) {
        return UserInterestName.format(String.valueOf(customerId), String.valueOf(categoryId));
    }

    public static String userList(long customerId, long userListId) {
        return UserListName.format(String.valueOf(customerId), String.valueOf(userListId));
    }

    public static String userLocationView(long customerId, long countryCriterionId, boolean isTargetingLocation) {
        return UserLocationViewName.format(String.valueOf(customerId), ResourceNames.concatIdentifiers(countryCriterionId, isTargetingLocation));
    }

    public static String video(long customerId, String videoId) {
        return VideoName.format(String.valueOf(customerId), videoId);
    }

    private static String concatIdentifiers(Object ... toConcat) {
        String pattern = Stream.of(toConcat).map(arg -> "%s").collect(Collectors.joining("~"));
        return String.format(pattern, toConcat);
    }
}

