/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v6.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CampaignExperimentName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_EXPERIMENT_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/campaignExperiments/{campaign_experiment_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignExperimentId;

    @Deprecated
    protected CampaignExperimentName() {
        this.customerId = null;
        this.campaignExperimentId = null;
    }

    private CampaignExperimentName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignExperimentId = (String)Preconditions.checkNotNull((Object)builder.getCampaignExperimentId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignExperimentId() {
        return this.campaignExperimentId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CampaignExperimentName of(String customerId, String campaignExperimentId) {
        return CampaignExperimentName.newBuilder().setCustomerId(customerId).setCampaignExperimentId(campaignExperimentId).build();
    }

    public static String format(String customerId, String campaignExperimentId) {
        return CampaignExperimentName.newBuilder().setCustomerId(customerId).setCampaignExperimentId(campaignExperimentId).build().toString();
    }

    public static CampaignExperimentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_EXPERIMENT_ID.validatedMatch(formattedString, "CampaignExperimentName.parse: formattedString not in valid format");
        return CampaignExperimentName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_experiment_id"));
    }

    public static List<CampaignExperimentName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignExperimentName> list = new ArrayList<CampaignExperimentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignExperimentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignExperimentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignExperimentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_EXPERIMENT_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignExperimentName campaignExperimentName = this;
            synchronized (campaignExperimentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignExperimentId != null) {
                        fieldMapBuilder.put((Object)"campaign_experiment_id", (Object)this.campaignExperimentId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_EXPERIMENT_ID.instantiate(new String[]{"customer_id", this.customerId, "campaign_experiment_id", this.campaignExperimentId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CampaignExperimentName that = (CampaignExperimentName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignExperimentId, that.campaignExperimentId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.campaignExperimentId);
    }

    public static class Builder {
        private String customerId;
        private String campaignExperimentId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignExperimentId() {
            return this.campaignExperimentId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignExperimentId(String campaignExperimentId) {
            this.campaignExperimentId = campaignExperimentId;
            return this;
        }

        private Builder(CampaignExperimentName campaignExperimentName) {
            this.customerId = campaignExperimentName.customerId;
            this.campaignExperimentId = campaignExperimentName.campaignExperimentId;
        }

        public CampaignExperimentName build() {
            return new CampaignExperimentName(this);
        }
    }
}

