/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v6.services;

import com.google.ads.googleads.v6.resources.BatchJob;
import com.google.ads.googleads.v6.resources.BatchJobName;
import com.google.ads.googleads.v6.services.AddBatchJobOperationsRequest;
import com.google.ads.googleads.v6.services.AddBatchJobOperationsResponse;
import com.google.ads.googleads.v6.services.BatchJobOperation;
import com.google.ads.googleads.v6.services.BatchJobResult;
import com.google.ads.googleads.v6.services.BatchJobServiceSettings;
import com.google.ads.googleads.v6.services.GetBatchJobRequest;
import com.google.ads.googleads.v6.services.ListBatchJobResultsRequest;
import com.google.ads.googleads.v6.services.ListBatchJobResultsResponse;
import com.google.ads.googleads.v6.services.MutateBatchJobRequest;
import com.google.ads.googleads.v6.services.MutateBatchJobResponse;
import com.google.ads.googleads.v6.services.MutateOperation;
import com.google.ads.googleads.v6.services.RunBatchJobRequest;
import com.google.ads.googleads.v6.services.stub.BatchJobServiceStub;
import com.google.ads.googleads.v6.services.stub.BatchJobServiceStubSettings;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class BatchJobServiceClient
implements BackgroundResource {
    private final BatchJobServiceSettings settings;
    private final BatchJobServiceStub stub;
    private final OperationsClient operationsClient;

    public static final BatchJobServiceClient create() throws IOException {
        return BatchJobServiceClient.create(BatchJobServiceSettings.newBuilder().build());
    }

    public static final BatchJobServiceClient create(BatchJobServiceSettings settings) throws IOException {
        return new BatchJobServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final BatchJobServiceClient create(BatchJobServiceStub stub) {
        return new BatchJobServiceClient(stub);
    }

    protected BatchJobServiceClient(BatchJobServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BatchJobServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected BatchJobServiceClient(BatchJobServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final BatchJobServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BatchJobServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final MutateBatchJobResponse mutateBatchJob(String customerId, BatchJobOperation operation) {
        MutateBatchJobRequest request = MutateBatchJobRequest.newBuilder().setCustomerId(customerId).setOperation(operation).build();
        return this.mutateBatchJob(request);
    }

    public final MutateBatchJobResponse mutateBatchJob(MutateBatchJobRequest request) {
        return (MutateBatchJobResponse)this.mutateBatchJobCallable().call((Object)request);
    }

    public final UnaryCallable<MutateBatchJobRequest, MutateBatchJobResponse> mutateBatchJobCallable() {
        return this.stub.mutateBatchJobCallable();
    }

    public final BatchJob getBatchJob(BatchJobName resourceName) {
        GetBatchJobRequest request = GetBatchJobRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getBatchJob(request);
    }

    public final BatchJob getBatchJob(String resourceName) {
        GetBatchJobRequest request = GetBatchJobRequest.newBuilder().setResourceName(resourceName).build();
        return this.getBatchJob(request);
    }

    public final BatchJob getBatchJob(GetBatchJobRequest request) {
        return (BatchJob)this.getBatchJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetBatchJobRequest, BatchJob> getBatchJobCallable() {
        return this.stub.getBatchJobCallable();
    }

    public final ListBatchJobResultsPagedResponse listBatchJobResults(BatchJobName resourceName) {
        ListBatchJobResultsRequest request = ListBatchJobResultsRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.listBatchJobResults(request);
    }

    public final ListBatchJobResultsPagedResponse listBatchJobResults(String resourceName) {
        ListBatchJobResultsRequest request = ListBatchJobResultsRequest.newBuilder().setResourceName(resourceName).build();
        return this.listBatchJobResults(request);
    }

    public final ListBatchJobResultsPagedResponse listBatchJobResults(ListBatchJobResultsRequest request) {
        return (ListBatchJobResultsPagedResponse)((Object)this.listBatchJobResultsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBatchJobResultsRequest, ListBatchJobResultsPagedResponse> listBatchJobResultsPagedCallable() {
        return this.stub.listBatchJobResultsPagedCallable();
    }

    public final UnaryCallable<ListBatchJobResultsRequest, ListBatchJobResultsResponse> listBatchJobResultsCallable() {
        return this.stub.listBatchJobResultsCallable();
    }

    public final OperationFuture<Empty, BatchJob.BatchJobMetadata> runBatchJobAsync(BatchJobName resourceName) {
        RunBatchJobRequest request = RunBatchJobRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.runBatchJobAsync(request);
    }

    public final OperationFuture<Empty, BatchJob.BatchJobMetadata> runBatchJobAsync(String resourceName) {
        RunBatchJobRequest request = RunBatchJobRequest.newBuilder().setResourceName(resourceName).build();
        return this.runBatchJobAsync(request);
    }

    public final OperationFuture<Empty, BatchJob.BatchJobMetadata> runBatchJobAsync(RunBatchJobRequest request) {
        return this.runBatchJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RunBatchJobRequest, Empty, BatchJob.BatchJobMetadata> runBatchJobOperationCallable() {
        return this.stub.runBatchJobOperationCallable();
    }

    public final UnaryCallable<RunBatchJobRequest, Operation> runBatchJobCallable() {
        return this.stub.runBatchJobCallable();
    }

    public final AddBatchJobOperationsResponse addBatchJobOperations(BatchJobName resourceName, List<MutateOperation> mutateOperations) {
        AddBatchJobOperationsRequest request = AddBatchJobOperationsRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).addAllMutateOperations(mutateOperations).build();
        return this.addBatchJobOperations(request);
    }

    public final AddBatchJobOperationsResponse addBatchJobOperations(String resourceName, List<MutateOperation> mutateOperations) {
        AddBatchJobOperationsRequest request = AddBatchJobOperationsRequest.newBuilder().setResourceName(resourceName).addAllMutateOperations(mutateOperations).build();
        return this.addBatchJobOperations(request);
    }

    public final AddBatchJobOperationsResponse addBatchJobOperations(BatchJobName resourceName, String sequenceToken, List<MutateOperation> mutateOperations) {
        AddBatchJobOperationsRequest request = AddBatchJobOperationsRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).setSequenceToken(sequenceToken).addAllMutateOperations(mutateOperations).build();
        return this.addBatchJobOperations(request);
    }

    public final AddBatchJobOperationsResponse addBatchJobOperations(String resourceName, String sequenceToken, List<MutateOperation> mutateOperations) {
        AddBatchJobOperationsRequest request = AddBatchJobOperationsRequest.newBuilder().setResourceName(resourceName).setSequenceToken(sequenceToken).addAllMutateOperations(mutateOperations).build();
        return this.addBatchJobOperations(request);
    }

    public final AddBatchJobOperationsResponse addBatchJobOperations(AddBatchJobOperationsRequest request) {
        return (AddBatchJobOperationsResponse)this.addBatchJobOperationsCallable().call((Object)request);
    }

    public final UnaryCallable<AddBatchJobOperationsRequest, AddBatchJobOperationsResponse> addBatchJobOperationsCallable() {
        return this.stub.addBatchJobOperationsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListBatchJobResultsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBatchJobResultsRequest, ListBatchJobResultsResponse, BatchJobResult, ListBatchJobResultsPage, ListBatchJobResultsFixedSizeCollection> {
        private ListBatchJobResultsFixedSizeCollection(List<ListBatchJobResultsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBatchJobResultsFixedSizeCollection createEmptyCollection() {
            return new ListBatchJobResultsFixedSizeCollection(null, 0);
        }

        protected ListBatchJobResultsFixedSizeCollection createCollection(List<ListBatchJobResultsPage> pages, int collectionSize) {
            return new ListBatchJobResultsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBatchJobResultsPage
    extends AbstractPage<ListBatchJobResultsRequest, ListBatchJobResultsResponse, BatchJobResult, ListBatchJobResultsPage> {
        private ListBatchJobResultsPage(PageContext<ListBatchJobResultsRequest, ListBatchJobResultsResponse, BatchJobResult> context, ListBatchJobResultsResponse response) {
            super(context, (Object)response);
        }

        private static ListBatchJobResultsPage createEmptyPage() {
            return new ListBatchJobResultsPage(null, null);
        }

        protected ListBatchJobResultsPage createPage(PageContext<ListBatchJobResultsRequest, ListBatchJobResultsResponse, BatchJobResult> context, ListBatchJobResultsResponse response) {
            return new ListBatchJobResultsPage(context, response);
        }

        public ApiFuture<ListBatchJobResultsPage> createPageAsync(PageContext<ListBatchJobResultsRequest, ListBatchJobResultsResponse, BatchJobResult> context, ApiFuture<ListBatchJobResultsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBatchJobResultsPagedResponse
    extends AbstractPagedListResponse<ListBatchJobResultsRequest, ListBatchJobResultsResponse, BatchJobResult, ListBatchJobResultsPage, ListBatchJobResultsFixedSizeCollection> {
        public static ApiFuture<ListBatchJobResultsPagedResponse> createAsync(PageContext<ListBatchJobResultsRequest, ListBatchJobResultsResponse, BatchJobResult> context, ApiFuture<ListBatchJobResultsResponse> futureResponse) {
            ApiFuture<ListBatchJobResultsPage> futurePage = ListBatchJobResultsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListBatchJobResultsPage, ListBatchJobResultsPagedResponse>(){

                public ListBatchJobResultsPagedResponse apply(ListBatchJobResultsPage input) {
                    return new ListBatchJobResultsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListBatchJobResultsPagedResponse(ListBatchJobResultsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBatchJobResultsFixedSizeCollection.createEmptyCollection());
        }
    }
}

