/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v6.services;

import com.google.ads.googleads.v6.resources.CustomerManagerLink;
import com.google.ads.googleads.v6.resources.CustomerManagerLinkName;
import com.google.ads.googleads.v6.services.CustomerManagerLinkOperation;
import com.google.ads.googleads.v6.services.CustomerManagerLinkServiceSettings;
import com.google.ads.googleads.v6.services.GetCustomerManagerLinkRequest;
import com.google.ads.googleads.v6.services.MoveManagerLinkRequest;
import com.google.ads.googleads.v6.services.MoveManagerLinkResponse;
import com.google.ads.googleads.v6.services.MutateCustomerManagerLinkRequest;
import com.google.ads.googleads.v6.services.MutateCustomerManagerLinkResponse;
import com.google.ads.googleads.v6.services.stub.CustomerManagerLinkServiceStub;
import com.google.ads.googleads.v6.services.stub.CustomerManagerLinkServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CustomerManagerLinkServiceClient
implements BackgroundResource {
    private final CustomerManagerLinkServiceSettings settings;
    private final CustomerManagerLinkServiceStub stub;

    public static final CustomerManagerLinkServiceClient create() throws IOException {
        return CustomerManagerLinkServiceClient.create(CustomerManagerLinkServiceSettings.newBuilder().build());
    }

    public static final CustomerManagerLinkServiceClient create(CustomerManagerLinkServiceSettings settings) throws IOException {
        return new CustomerManagerLinkServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CustomerManagerLinkServiceClient create(CustomerManagerLinkServiceStub stub) {
        return new CustomerManagerLinkServiceClient(stub);
    }

    protected CustomerManagerLinkServiceClient(CustomerManagerLinkServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CustomerManagerLinkServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CustomerManagerLinkServiceClient(CustomerManagerLinkServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CustomerManagerLinkServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CustomerManagerLinkServiceStub getStub() {
        return this.stub;
    }

    public final CustomerManagerLink getCustomerManagerLink(CustomerManagerLinkName resourceName) {
        GetCustomerManagerLinkRequest request = GetCustomerManagerLinkRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getCustomerManagerLink(request);
    }

    public final CustomerManagerLink getCustomerManagerLink(String resourceName) {
        GetCustomerManagerLinkRequest request = GetCustomerManagerLinkRequest.newBuilder().setResourceName(resourceName).build();
        return this.getCustomerManagerLink(request);
    }

    public final CustomerManagerLink getCustomerManagerLink(GetCustomerManagerLinkRequest request) {
        return (CustomerManagerLink)this.getCustomerManagerLinkCallable().call((Object)request);
    }

    public final UnaryCallable<GetCustomerManagerLinkRequest, CustomerManagerLink> getCustomerManagerLinkCallable() {
        return this.stub.getCustomerManagerLinkCallable();
    }

    public final MutateCustomerManagerLinkResponse mutateCustomerManagerLink(String customerId, List<CustomerManagerLinkOperation> operations) {
        MutateCustomerManagerLinkRequest request = MutateCustomerManagerLinkRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateCustomerManagerLink(request);
    }

    public final MutateCustomerManagerLinkResponse mutateCustomerManagerLink(MutateCustomerManagerLinkRequest request) {
        return (MutateCustomerManagerLinkResponse)this.mutateCustomerManagerLinkCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCustomerManagerLinkRequest, MutateCustomerManagerLinkResponse> mutateCustomerManagerLinkCallable() {
        return this.stub.mutateCustomerManagerLinkCallable();
    }

    public final MoveManagerLinkResponse moveManagerLink(String customerId, String previousCustomerManagerLink, String newManager) {
        MoveManagerLinkRequest request = MoveManagerLinkRequest.newBuilder().setCustomerId(customerId).setPreviousCustomerManagerLink(previousCustomerManagerLink).setNewManager(newManager).build();
        return this.moveManagerLink(request);
    }

    public final MoveManagerLinkResponse moveManagerLink(MoveManagerLinkRequest request) {
        return (MoveManagerLinkResponse)this.moveManagerLinkCallable().call((Object)request);
    }

    public final UnaryCallable<MoveManagerLinkRequest, MoveManagerLinkResponse> moveManagerLinkCallable() {
        return this.stub.moveManagerLinkCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

