/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v6.services;

import com.google.ads.googleads.v6.resources.HotelGroupView;
import com.google.ads.googleads.v6.resources.HotelGroupViewName;
import com.google.ads.googleads.v6.services.GetHotelGroupViewRequest;
import com.google.ads.googleads.v6.services.HotelGroupViewServiceSettings;
import com.google.ads.googleads.v6.services.stub.HotelGroupViewServiceStub;
import com.google.ads.googleads.v6.services.stub.HotelGroupViewServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class HotelGroupViewServiceClient
implements BackgroundResource {
    private final HotelGroupViewServiceSettings settings;
    private final HotelGroupViewServiceStub stub;

    public static final HotelGroupViewServiceClient create() throws IOException {
        return HotelGroupViewServiceClient.create(HotelGroupViewServiceSettings.newBuilder().build());
    }

    public static final HotelGroupViewServiceClient create(HotelGroupViewServiceSettings settings) throws IOException {
        return new HotelGroupViewServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final HotelGroupViewServiceClient create(HotelGroupViewServiceStub stub) {
        return new HotelGroupViewServiceClient(stub);
    }

    protected HotelGroupViewServiceClient(HotelGroupViewServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((HotelGroupViewServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected HotelGroupViewServiceClient(HotelGroupViewServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final HotelGroupViewServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public HotelGroupViewServiceStub getStub() {
        return this.stub;
    }

    public final HotelGroupView getHotelGroupView(HotelGroupViewName resourceName) {
        GetHotelGroupViewRequest request = GetHotelGroupViewRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getHotelGroupView(request);
    }

    public final HotelGroupView getHotelGroupView(String resourceName) {
        GetHotelGroupViewRequest request = GetHotelGroupViewRequest.newBuilder().setResourceName(resourceName).build();
        return this.getHotelGroupView(request);
    }

    public final HotelGroupView getHotelGroupView(GetHotelGroupViewRequest request) {
        return (HotelGroupView)this.getHotelGroupViewCallable().call((Object)request);
    }

    public final UnaryCallable<GetHotelGroupViewRequest, HotelGroupView> getHotelGroupViewCallable() {
        return this.stub.getHotelGroupViewCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

