/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v6.services;

import com.google.ads.googleads.v6.resources.UserLocationView;
import com.google.ads.googleads.v6.resources.UserLocationViewName;
import com.google.ads.googleads.v6.services.GetUserLocationViewRequest;
import com.google.ads.googleads.v6.services.UserLocationViewServiceSettings;
import com.google.ads.googleads.v6.services.stub.UserLocationViewServiceStub;
import com.google.ads.googleads.v6.services.stub.UserLocationViewServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class UserLocationViewServiceClient
implements BackgroundResource {
    private final UserLocationViewServiceSettings settings;
    private final UserLocationViewServiceStub stub;

    public static final UserLocationViewServiceClient create() throws IOException {
        return UserLocationViewServiceClient.create(UserLocationViewServiceSettings.newBuilder().build());
    }

    public static final UserLocationViewServiceClient create(UserLocationViewServiceSettings settings) throws IOException {
        return new UserLocationViewServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final UserLocationViewServiceClient create(UserLocationViewServiceStub stub) {
        return new UserLocationViewServiceClient(stub);
    }

    protected UserLocationViewServiceClient(UserLocationViewServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((UserLocationViewServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected UserLocationViewServiceClient(UserLocationViewServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final UserLocationViewServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public UserLocationViewServiceStub getStub() {
        return this.stub;
    }

    public final UserLocationView getUserLocationView(UserLocationViewName resourceName) {
        GetUserLocationViewRequest request = GetUserLocationViewRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getUserLocationView(request);
    }

    public final UserLocationView getUserLocationView(String resourceName) {
        GetUserLocationViewRequest request = GetUserLocationViewRequest.newBuilder().setResourceName(resourceName).build();
        return this.getUserLocationView(request);
    }

    public final UserLocationView getUserLocationView(GetUserLocationViewRequest request) {
        return (UserLocationView)this.getUserLocationViewCallable().call((Object)request);
    }

    public final UnaryCallable<GetUserLocationViewRequest, UserLocationView> getUserLocationViewCallable() {
        return this.stub.getUserLocationViewCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

